/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jolokia;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.jolokia.BearerTokenAuthenticator;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.jolokia.client.BasicAuthenticator;
import org.jolokia.client.J4pAuthenticator;
import org.jolokia.client.J4pClient;
import org.jolokia.client.J4pClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JolokiaClients {
    private static final transient Logger LOG = LoggerFactory.getLogger(JolokiaClients.class);
    private final KubernetesClient kubernetes;
    private String user = Systems.getEnvVarOrSystemProperty((String)"JOLOKIA_USER", (String)"JOLOKIA_USER", (String)"admin");
    private String password = Systems.getEnvVarOrSystemProperty((String)"JOLOKIA_PASSWORD", (String)"JOLOKIA_PASSWORD", (String)"admin");
    private String protocol = Systems.getEnvVarOrSystemProperty((String)"JOLOKIA_PROTOCOL");
    private Filter<Pod> podFilter = null;
    private boolean useKubeProxy = true;
    private AuthenticationMode authenticationMode;

    public JolokiaClients() {
        this((KubernetesClient)new DefaultKubernetesClient());
    }

    public JolokiaClients(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
        if (Systems.hasEnvVarOrSystemProperty((String)"JOLOKIA_AUTHENTICATION_MODE")) {
            this.authenticationMode = AuthenticationMode.valueOf(Systems.getEnvVarOrSystemProperty((String)"JOLOKIA_AUTHENTICATION_MODE"));
        }
    }

    public KubernetesClient getKubernetes() {
        return this.kubernetes;
    }

    public J4pClient assertClientForReplicationController(String replicationControllerName) {
        J4pClient client = this.clientForReplicationController(replicationControllerName);
        io.fabric8.utils.Objects.assertNotNull((Object)client, (String)("No client for replicationController: " + replicationControllerName));
        return client;
    }

    public J4pClient assertClientForReplicationController(String replicationControllerName, String namespace) {
        J4pClient client = this.clientForReplicationController(replicationControllerName, namespace);
        io.fabric8.utils.Objects.assertNotNull((Object)client, (String)("No client for replicationController: " + replicationControllerName));
        return client;
    }

    public J4pClient assertClientForService(String serviceName) {
        J4pClient client = this.clientForService(serviceName);
        io.fabric8.utils.Objects.assertNotNull((Object)client, (String)("No client for service: " + serviceName));
        return client;
    }

    public J4pClient assertClientForService(String serviceName, String namespace) {
        J4pClient client = this.clientForService(serviceName, namespace);
        io.fabric8.utils.Objects.assertNotNull((Object)client, (String)("No client for service: " + serviceName));
        return client;
    }

    public J4pClient clientForReplicationController(ReplicationController replicationController) {
        Objects.requireNonNull(replicationController, "ReplicationController");
        PodList podList = (PodList)((ClientNonNamespaceOperation)this.kubernetes.pods().inNamespace(replicationController.getMetadata().getNamespace())).list();
        List items = null;
        if (podList != null) {
            items = podList.getItems();
        }
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException("No pods found for ReplicationController " + KubernetesHelper.summaryText((ReplicationController)replicationController));
        }
        List pods = KubernetesHelper.getPodsForReplicationController((ReplicationController)replicationController, (Iterable)items);
        return this.clientForPod(pods);
    }

    public J4pClient clientForReplicationController(String replicationControllerName, String namespace) {
        ReplicationController replicationController = this.requireReplicationController(replicationControllerName, namespace);
        return this.clientForReplicationController(replicationController);
    }

    public J4pClient clientForReplicationController(String replicationControllerName) {
        ReplicationController replicationController = (ReplicationController)((ClientRollableScallableResource)this.kubernetes.replicationControllers().withName(replicationControllerName)).get();
        Objects.requireNonNull(replicationController, "No ReplicationController found for name: " + replicationControllerName);
        return this.clientForReplicationController(replicationController);
    }

    public List<J4pClient> clientsForReplicationController(ReplicationController replicationController) {
        List pods = KubernetesHelper.getPodsForReplicationController((ReplicationController)replicationController, (Iterable)((PodList)((ClientNonNamespaceOperation)this.kubernetes.pods().inNamespace(replicationController.getMetadata().getNamespace())).list()).getItems());
        return this.clientsForPod(pods);
    }

    public List<J4pClient> clientsForReplicationController(String replicationControllerName, String namespace) {
        ReplicationController replicationController = this.requireReplicationController(replicationControllerName, namespace);
        List pods = KubernetesHelper.getPodsForReplicationController((ReplicationController)replicationController, (Iterable)((PodList)((ClientNonNamespaceOperation)this.kubernetes.pods().inNamespace(namespace)).list()).getItems());
        return this.clientsForPod(pods);
    }

    public J4pClient clientForService(String serviceName, String namespace) {
        List pods = KubernetesHelper.getPodsForService((Service)this.requireService(serviceName, namespace), (Iterable)((PodList)((ClientNonNamespaceOperation)this.kubernetes.pods().inNamespace(namespace)).list()).getItems());
        return this.clientForPod(pods);
    }

    public J4pClient clientForService(String serviceName) {
        List pods = KubernetesHelper.getPodsForService((Service)this.requireService(serviceName), (Iterable)((PodList)this.kubernetes.pods().list()).getItems());
        return this.clientForPod(pods);
    }

    public J4pClient clientForService(Service service) {
        List pods = KubernetesHelper.getPodsForService((Service)service, (Iterable)((PodList)((ClientNonNamespaceOperation)this.kubernetes.pods().inNamespace(service.getMetadata().getNamespace())).list()).getItems());
        return this.clientForPod(pods);
    }

    public List<J4pClient> clientsForService(String serviceName, String namespace) {
        List pods = KubernetesHelper.getPodsForService((Service)this.requireService(serviceName, namespace), (Iterable)((PodList)((ClientNonNamespaceOperation)this.kubernetes.pods().inNamespace(namespace)).list()).getItems());
        return this.clientsForPod(pods);
    }

    public List<J4pClient> clientsForService(String serviceName) {
        List pods = KubernetesHelper.getPodsForService((Service)this.requireService(serviceName), (Iterable)((PodList)this.kubernetes.pods().list()).getItems());
        return this.clientsForPod(pods);
    }

    public List<J4pClient> clientsForService(Service service) {
        List pods = KubernetesHelper.getPodsForService((Service)service, (Iterable)((PodList)((ClientNonNamespaceOperation)this.kubernetes.pods().inNamespace(service.getMetadata().getNamespace())).list()).getItems());
        return this.clientsForPod(pods);
    }

    public J4pClient clientForPod(Iterable<Pod> pods) {
        for (Pod pod : pods) {
            J4pClient client;
            if (!KubernetesHelper.isPodRunning((Pod)pod) || !this.filterPod(pod) || (client = this.clientForPod(pod)) == null) continue;
            return client;
        }
        return null;
    }

    public List<J4pClient> clientsForPod(Iterable<Pod> pods) {
        ArrayList<J4pClient> answer = new ArrayList<J4pClient>();
        for (Pod pod : pods) {
            J4pClient client;
            if (!KubernetesHelper.isPodRunning((Pod)pod) || !this.filterPod(pod) || (client = this.clientForPod(pod)) == null) continue;
            answer.add(client);
        }
        return answer;
    }

    protected boolean filterPod(Pod pod) {
        if (this.podFilter != null) {
            return this.podFilter.matches((Object)pod);
        }
        return true;
    }

    public J4pClient clientForPod(Pod pod) {
        String host = KubernetesHelper.getHost((Pod)pod);
        List containers = KubernetesHelper.getContainers((Pod)pod);
        for (Container container : containers) {
            J4pClient jolokia = this.clientForContainer(host, container, pod);
            if (jolokia == null) continue;
            return jolokia;
        }
        return null;
    }

    public J4pClient clientForContainer(String host, Container container, Pod pod) {
        if (container != null) {
            List ports = container.getPorts();
            for (ContainerPort port : ports) {
                String dockerIp;
                Integer containerPort = port.getContainerPort();
                if (containerPort == null) continue;
                String name = port.getName();
                if (containerPort != 8778 && (!Objects.equals("jolokia", name) || containerPort <= 0)) continue;
                if (this.useKubeProxy) {
                    URL masterUrl = this.getKubernetes().getMasterUrl();
                    ObjectMeta metadata = pod.getMetadata();
                    String namespace = metadata.getNamespace();
                    String podName = metadata.getName();
                    String jolokiaUrl = URLUtils.join((String[])new String[]{masterUrl.toString(), "/api/v1/namespaces/" + namespace + "/pods/" + this.locateJolokiaProtocol() + ":" + podName + ":8778/proxy/jolokia/"});
                    LOG.info("Using jolokia URL: " + jolokiaUrl);
                    return this.createJolokiaClient(container, jolokiaUrl);
                }
                PodStatus currentState = pod.getStatus();
                String podIP = currentState.getPodIP();
                if (Strings.isNotBlank((String)podIP)) {
                    return this.createJolokiaClientFromHostAndPort(container, podIP, containerPort);
                }
                Integer hostPort = port.getHostPort();
                if (hostPort != null && this.hasDocker(pod) && (host.equals("localhost") || host.equals("127.0.0.1")) && Strings.isNotBlank((String)(dockerIp = KubernetesHelper.getDockerIp()))) {
                    host = dockerIp;
                }
                if (!Strings.isNotBlank((String)host)) continue;
                return this.createJolokiaClientFromHostAndPort(container, host, hostPort);
            }
        }
        return null;
    }

    protected J4pClient createJolokiaClientFromHostAndPort(Container container, String host, Integer hostPort) {
        String jolokiaUrl = this.locateJolokiaProtocol() + "://" + host + ":" + hostPort + "/jolokia/";
        return this.createJolokiaClient(container, jolokiaUrl);
    }

    protected boolean hasDocker(Pod pod) {
        PodStatus currentState = pod.getStatus();
        if (currentState != null) {
            List list = currentState.getContainerStatuses();
        }
        return false;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUseKubeProxy() {
        return this.useKubeProxy;
    }

    public void setUseKubeProxy(boolean useKubeProxy) {
        this.useKubeProxy = useKubeProxy;
    }

    public Filter<Pod> getPodFilter() {
        return this.podFilter;
    }

    public void setPodFilter(Filter<Pod> podFilter) {
        this.podFilter = podFilter;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public AuthenticationMode getAuthenticationMode() {
        return this.authenticationMode;
    }

    public void setAuthenticationMode(AuthenticationMode authenticationMode) {
        this.authenticationMode = authenticationMode;
    }

    protected J4pClient createJolokiaClient(Container container, String jolokiaUrl) {
        URL masterUrl;
        String name = container.getName();
        LOG.debug("Creating jolokia client for : " + name + " at URL: " + jolokiaUrl);
        J4pClientBuilder builder = J4pClient.url((String)jolokiaUrl);
        if (this.useKubeProxy && (masterUrl = this.getKubernetes().getMasterUrl()) != null && masterUrl.toString().startsWith("https")) {
            try {
                SSLContext sslCtx = SSLUtils.sslContext((Config)this.kubernetes.getConfiguration());
                SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(sslCtx);
                builder = builder.sslConnectionSocketFactory((ConnectionSocketFactory)factory);
            }
            catch (Exception e) {
                LOG.warn("Unable to inject the Kubernetes SSL context into the Jolokia client. Using the default context", (Throwable)e);
            }
        }
        AuthenticationMode mode = this.locateAuthenticationMode();
        switch (mode) {
            case BEARER: {
                builder = builder.authenticator((J4pAuthenticator)new BearerTokenAuthenticator());
                String token = this.kubernetes.getConfiguration().getOauthToken();
                builder = builder.user(token);
                break;
            }
            case BASIC: {
                builder = builder.authenticator((J4pAuthenticator)new BasicAuthenticator());
                if (Strings.isNotBlank((String)this.user)) {
                    builder = builder.user(this.user);
                }
                if (!Strings.isNotBlank((String)this.password)) break;
                builder = builder.password(this.password);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported authentication mode: " + (Object)((Object)mode));
            }
        }
        return builder.build();
    }

    protected String locateJolokiaProtocol() {
        if (this.protocol != null) {
            return this.protocol;
        }
        if (KubernetesHelper.isOpenShift((KubernetesClient)this.kubernetes)) {
            return "https";
        }
        return "http";
    }

    protected AuthenticationMode locateAuthenticationMode() {
        if (this.authenticationMode != null) {
            return this.authenticationMode;
        }
        if (KubernetesHelper.isOpenShift((KubernetesClient)this.kubernetes)) {
            return AuthenticationMode.BEARER;
        }
        return AuthenticationMode.BASIC;
    }

    protected ReplicationController requireReplicationController(String replicationControllerName, String namespace) {
        ReplicationController answer = (ReplicationController)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.kubernetes.replicationControllers().inNamespace(namespace)).withName(replicationControllerName)).get();
        Objects.requireNonNull(answer, "No ReplicationController found for namespace: " + namespace + " name: " + replicationControllerName);
        return answer;
    }

    protected Service requireService(String serviceName) {
        Service answer = (Service)((ClientResource)this.kubernetes.services().withName(serviceName)).get();
        Objects.requireNonNull(answer, "No Service found for name: " + serviceName);
        return answer;
    }

    protected Service requireService(String serviceName, String namespace) {
        Service answer = (Service)((ClientResource)((ClientNonNamespaceOperation)this.kubernetes.services().inNamespace(namespace)).withName(serviceName)).get();
        Objects.requireNonNull(answer, "No Service found for namespace: " + namespace + " name: " + serviceName);
        return answer;
    }

    public static enum AuthenticationMode {
        BASIC,
        BEARER;

    }
}

