/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.jetty.JettyHttpClient;
import io.fabric8.kubernetes.client.jetty.JettyHttpClientFactory;
import java.time.Duration;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.dynamic.HttpClientTransportDynamic;
import org.eclipse.jetty.client.http.HttpClientConnectionFactory;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.ClientConnectionFactoryOverHTTP2;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class JettyHttpClientBuilder
extends StandardHttpClientBuilder<JettyHttpClient, JettyHttpClientFactory, JettyHttpClientBuilder> {
    private static final int MAX_CONNECTIONS = Integer.MAX_VALUE;
    private static final int MAX_WS_MESSAGE_SIZE = Integer.MAX_VALUE;

    public JettyHttpClientBuilder(JettyHttpClientFactory clientFactory) {
        super((HttpClient.Factory)clientFactory);
        this.preferHttp11 = true;
    }

    public JettyHttpClient build() {
        if (this.client != null) {
            return new JettyHttpClient(this, ((JettyHttpClient)this.client).getJetty(), ((JettyHttpClient)this.client).getJettyWs());
        }
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        if (this.sslContext != null) {
            sslContextFactory.setSslContext(this.sslContext);
        }
        if (this.tlsVersions != null && this.tlsVersions.length > 0) {
            sslContextFactory.setIncludeProtocols((String[])Stream.of(this.tlsVersions).map(TlsVersion::javaName).toArray(String[]::new));
        }
        HttpClient sharedHttpClient = new HttpClient(JettyHttpClientBuilder.newTransport(sslContextFactory, this.preferHttp11));
        WebSocketClient sharedWebSocketClient = new WebSocketClient(new HttpClient(JettyHttpClientBuilder.newTransport(sslContextFactory, this.preferHttp11)));
        sharedWebSocketClient.setMaxBinaryMessageSize(Integer.MAX_VALUE);
        sharedWebSocketClient.setMaxFrameSize(Integer.MAX_VALUE);
        sharedWebSocketClient.setMaxTextMessageSize(Integer.MAX_VALUE);
        sharedWebSocketClient.setIdleTimeout(Duration.ZERO);
        if (this.connectTimeout != null) {
            sharedHttpClient.setConnectTimeout(this.connectTimeout.toMillis());
            sharedWebSocketClient.setConnectTimeout(this.connectTimeout.toMillis());
        }
        sharedHttpClient.setFollowRedirects(this.followRedirects);
        sharedHttpClient.setMaxConnectionsPerDestination(Integer.MAX_VALUE);
        sharedWebSocketClient.getHttpClient().setMaxConnectionsPerDestination(Integer.MAX_VALUE);
        if (this.proxyType != HttpClient.ProxyType.DIRECT && this.proxyAddress != null) {
            Origin.Address address = new Origin.Address(this.proxyAddress.getHostString(), this.proxyAddress.getPort());
            switch (this.proxyType) {
                case HTTP: {
                    sharedHttpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)new HttpProxy(address, false));
                    break;
                }
                case SOCKS4: {
                    sharedHttpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)new Socks4Proxy(address, false));
                    break;
                }
                default: {
                    throw new KubernetesClientException("Unsupported proxy type");
                }
            }
            sharedHttpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)new HttpProxy(address, false));
            this.addProxyAuthInterceptor();
        }
        ((JettyHttpClientFactory)this.clientFactory).additionalConfig(sharedHttpClient, sharedWebSocketClient);
        return new JettyHttpClient(this, sharedHttpClient, sharedWebSocketClient);
    }

    private static HttpClientTransport newTransport(SslContextFactory.Client sslContextFactory, boolean preferHttp11) {
        HttpClientTransportOverHTTP transport;
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setSslContextFactory(sslContextFactory);
        if (preferHttp11) {
            transport = new HttpClientTransportOverHTTP(clientConnector);
        } else {
            ClientConnectionFactoryOverHTTP2.HTTP2 http2 = new ClientConnectionFactoryOverHTTP2.HTTP2(new HTTP2Client(clientConnector));
            transport = new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[]{http2, HttpClientConnectionFactory.HTTP11});
        }
        return transport;
    }

    protected JettyHttpClientBuilder newInstance(JettyHttpClientFactory clientFactory) {
        return new JettyHttpClientBuilder(clientFactory);
    }

    public Duration getConnectTimeout() {
        return Optional.ofNullable(this.connectTimeout).orElse(Duration.ZERO);
    }
}

