/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.jetty.JettyAsyncResponseListener;
import io.fabric8.kubernetes.client.jetty.JettyHttpClientBuilder;
import io.fabric8.kubernetes.client.jetty.JettyHttpClientFactory;
import io.fabric8.kubernetes.client.jetty.JettyHttpResponse;
import io.fabric8.kubernetes.client.jetty.JettyWebSocketBuilder;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.InputStreamRequestContent;
import org.eclipse.jetty.client.util.StringRequestContent;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class JettyHttpClient
implements io.fabric8.kubernetes.client.http.HttpClient {
    private final HttpClient jetty;
    private final WebSocketClient jettyWs;
    private final Collection<Interceptor> interceptors;
    private final JettyHttpClientBuilder builder;
    private final JettyHttpClientFactory factory;
    private Config config;

    public JettyHttpClient(JettyHttpClientBuilder builder, HttpClient httpClient, WebSocketClient webSocketClient, Collection<Interceptor> interceptors, JettyHttpClientFactory jettyHttpClientFactory, Config config) {
        this.builder = builder;
        this.jetty = httpClient;
        this.jettyWs = webSocketClient;
        this.interceptors = interceptors;
        this.factory = jettyHttpClientFactory;
        this.config = config;
    }

    public void close() {
        try {
            this.jetty.stop();
            this.jettyWs.stop();
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public HttpClient.DerivedClientBuilder newBuilder() {
        return this.builder.copy(this);
    }

    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest originalRequest, final Class<T> type) {
        final JettyHttpResponse.SupportedResponse supportedResponse = JettyHttpResponse.SupportedResponse.from(type);
        final StandardHttpRequest request = JettyHttpClient.toStandardHttpRequest(originalRequest);
        final CompletableFuture<HttpResponse<T>> future = new CompletableFuture<HttpResponse<T>>();
        this.newRequest(request).send((Response.CompleteListener)new BufferingResponseListener(){

            public void onComplete(Result result) {
                future.complete(new JettyHttpResponse((HttpRequest)request, result.getResponse(), supportedResponse.process(result.getResponse(), this.getContent(), type)));
            }
        });
        return this.interceptResponse(request.toBuilder(), future, r -> this.sendAsync((HttpRequest)r, type));
    }

    public CompletableFuture<HttpResponse<HttpClient.AsyncBody>> consumeLines(HttpRequest originalRequest, HttpClient.BodyConsumer<String> consumer) {
        StandardHttpRequest request = JettyHttpClient.toStandardHttpRequest(originalRequest);
        CompletableFuture future = new JettyAsyncResponseListener<String>((HttpRequest)request, consumer){

            @Override
            protected String process(Response response, ByteBuffer content) {
                return JettyHttpResponse.SupportedResponse.TEXT.process(response, BufferUtil.toArray((ByteBuffer)content), String.class);
            }
        }.listen(this.newRequest(request));
        return this.interceptResponse(request.toBuilder(), future, r -> this.consumeLines((HttpRequest)r, consumer));
    }

    public CompletableFuture<HttpResponse<HttpClient.AsyncBody>> consumeBytes(HttpRequest originalRequest, HttpClient.BodyConsumer<List<ByteBuffer>> consumer) {
        StandardHttpRequest request = JettyHttpClient.toStandardHttpRequest(originalRequest);
        CompletableFuture future = new JettyAsyncResponseListener<List<ByteBuffer>>((HttpRequest)request, consumer){

            @Override
            protected List<ByteBuffer> process(Response response, ByteBuffer content) {
                return Collections.singletonList(content);
            }
        }.listen(this.newRequest(request));
        return this.interceptResponse(request.toBuilder(), future, r -> this.consumeBytes((HttpRequest)r, consumer));
    }

    public WebSocket.Builder newWebSocketBuilder() {
        return new JettyWebSocketBuilder(this.jettyWs, this.builder.getReadTimeout());
    }

    public HttpRequest.Builder newHttpRequestBuilder() {
        return new StandardHttpRequest.Builder();
    }

    public HttpClient.Factory getFactory() {
        return this.factory;
    }

    private Request newRequest(StandardHttpRequest originalRequest) {
        try {
            this.jetty.start();
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        StandardHttpRequest.Builder requestBuilder = originalRequest.toBuilder();
        this.interceptors.forEach(i -> Interceptor.useConfig((Interceptor)i, (Config)this.config).before((BasicBuilder)requestBuilder, (HttpHeaders)originalRequest));
        StandardHttpRequest request = requestBuilder.build();
        Request jettyRequest = this.jetty.newRequest(request.uri()).method(request.method());
        jettyRequest.timeout(this.builder.getReadTimeout().toMillis() + this.builder.getWriteTimeout().toMillis(), TimeUnit.MILLISECONDS);
        jettyRequest.headers(m -> request.headers().forEach((k, l) -> l.forEach(v -> m.add(k, v))));
        Optional contentType = request.headers("Content-Type").stream().findAny();
        if (request.bodyString() != null) {
            jettyRequest.body((Request.Content)new StringRequestContent(contentType.orElse("text/plain"), request.bodyString()));
        } else if (request.bodyStream() != null) {
            jettyRequest.body((Request.Content)new InputStreamRequestContent(contentType.orElse("application/octet-stream"), request.bodyStream()));
        }
        return jettyRequest;
    }

    private <T> CompletableFuture<HttpResponse<T>> interceptResponse(StandardHttpRequest.Builder builder, CompletableFuture<HttpResponse<T>> originalResponse, Function<HttpRequest, CompletableFuture<HttpResponse<T>>> function) {
        for (Interceptor interceptor : this.interceptors) {
            originalResponse = originalResponse.thenCompose(r -> {
                if (!r.isSuccessful()) {
                    return Interceptor.useConfig((Interceptor)interceptor, (Config)this.config).afterFailure((HttpRequest.Builder)builder, r).thenCompose(b -> {
                        if (Boolean.TRUE.equals(b)) {
                            return (CompletionStage)function.apply((HttpRequest)builder.build());
                        }
                        return CompletableFuture.completedFuture(r);
                    });
                }
                return CompletableFuture.completedFuture(r);
            });
        }
        return originalResponse;
    }

    private static StandardHttpRequest toStandardHttpRequest(HttpRequest request) {
        if (!(request instanceof StandardHttpRequest)) {
            throw new IllegalArgumentException("Only StandardHttpRequest is supported");
        }
        return (StandardHttpRequest)request;
    }

    HttpClient getJetty() {
        return this.jetty;
    }

    WebSocketClient getJettyWs() {
        return this.jettyWs;
    }
}

