/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jdkhttp;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientBuilderImpl;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientImpl;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.http.HttpClient;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class JdkHttpClientFactory
implements HttpClient.Factory {
    public JdkHttpClientBuilderImpl newBuilder() {
        return new JdkHttpClientBuilderImpl(this);
    }

    protected void additionalConfig(HttpClient.Builder builder) {
    }

    protected HttpClient.Builder createNewHttpClientBuilder() {
        ExecutorService ex = Executors.newCachedThreadPool(Utils.daemonThreadFactory((Object)this));
        return HttpClient.newBuilder().executor(new ShutdownableExecutor(ex));
    }

    protected void closeHttpClient(JdkHttpClientImpl jdkHttpClientImpl) {
        jdkHttpClientImpl.getHttpClient().executor().filter(ShutdownableExecutor.class::isInstance).map(ShutdownableExecutor.class::cast).ifPresent(ShutdownableExecutor::shutdownNow);
    }

    static class ShutdownableExecutor
    implements Executor {
        private ExecutorService es;

        public ShutdownableExecutor(ExecutorService es) {
            this.es = es;
        }

        @Override
        public void execute(Runnable command) {
            this.es.execute(command);
        }

        public void shutdownNow() {
            this.es.shutdownNow();
        }
    }
}

