/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.generator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.kubernetes.api.model.KubernetesList;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.processing.AbstractProcessor;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public abstract class AbstractKubernetesAnnotationProcessor
extends AbstractProcessor {
    private static final String KUBERNETES_JSON = "kubernetes.json";
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    KubernetesList readJson() {
        try {
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", KUBERNETES_JSON);
            try (Reader reader = fileObject.openReader(false);){
                KubernetesList kubernetesList = (KubernetesList)MAPPER.readValue(reader, KubernetesList.class);
                return kubernetesList;
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Kubernetes json not found.");
            return null;
        }
    }

    void generateJson(KubernetesList list) {
        try {
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", KUBERNETES_JSON);
            Path path = Paths.get(fileObject.toUri());
            File file = path.toFile();
            if (file.exists() && !file.delete()) {
                throw new IOException("Failed to delete old kubernetes json.");
            }
            fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", KUBERNETES_JSON, new Element[0]);
            try (Writer writer = fileObject.openWriter();){
                MAPPER.writeValue(writer, (Object)list);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error generating json.");
        }
    }

    TypeElement getClassElement(Element element) {
        if (element instanceof PackageElement) {
            throw new IllegalArgumentException("Invalid element. A package element can't be used to retrieve a class element");
        }
        if (element instanceof TypeElement && element.getEnclosingElement() instanceof PackageElement) {
            return (TypeElement)element;
        }
        return this.getClassElement(element.getEnclosingElement());
    }

    PackageElement getPackageElement(Element element) {
        if (element instanceof PackageElement) {
            return (PackageElement)element;
        }
        return this.getPackageElement(element.getEnclosingElement());
    }
}

