/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListExamples {
    private static final Logger logger = LoggerFactory.getLogger(ListExamples.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
        }
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            String namespace = Optional.ofNullable(client.getNamespace()).orElse("default");
            System.out.println(client.namespaces().list());
            System.out.println(((FilterWatchListDeletable)client.namespaces().withLabel("this", "works")).list());
            System.out.println(((FilterWatchListDeletable)client.pods().withLabel("this", "works")).list());
            System.out.println(((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace("test")).withLabel("this", "works")).list());
            System.out.println(((PodResource)((NonNamespaceOperation)client.pods().inNamespace("test")).withName("testing")).get());
            PodList podList = (PodList)((NonNamespaceOperation)client.pods().inNamespace(namespace)).list(((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).build());
            podList.getItems().forEach(obj -> System.out.println(obj.getMetadata().getName()));
            podList = (PodList)((NonNamespaceOperation)client.pods().inNamespace(namespace)).list(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue(podList.getMetadata().getContinue())).build());
            podList.getItems().forEach(obj -> System.out.println(obj.getMetadata().getName()));
            Integer services = ((ServiceList)((NonNamespaceOperation)client.services().inNamespace(namespace)).list(((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(1L))).build())).getItems().size();
            ((NonNamespaceOperation)client.services().inNamespace(namespace)).list(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(1L))).withContinue(null)).build());
            System.out.println(services);
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

