/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;

public class AttachExample {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: podName [namespace]");
            return;
        }
        String podName = args[0];
        String namespace = "default";
        if (args.length > 1) {
            namespace = args[1];
        }
        CompletableFuture<Void> sessionFuture = new CompletableFuture<Void>();
        try (KubernetesClient client = new KubernetesClientBuilder().build();
             ExecWatch watch = AttachExample.attach(client, namespace, podName, sessionFuture);){
            System.out.println("Type 'exit' to detach");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                String input;
                if ((input = reader.readLine()).equals("exit")) {
                    return;
                }
                watch.getInput().write((input + "\n").getBytes(StandardCharsets.UTF_8));
                watch.getInput().flush();
                if (!sessionFuture.isDone()) continue;
                System.out.println("Session closed");
                return;
            }
        }
    }

    private static ExecWatch attach(KubernetesClient client, String namespace, String podName, final CompletableFuture<Void> sessionFuture) {
        return ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).redirectingInput().writingOutput((OutputStream)System.out).writingError((OutputStream)System.err).withTTY().usingListener(new ExecListener(){

            public void onFailure(Throwable t, ExecListener.Response failureResponse) {
                sessionFuture.complete(null);
            }

            public void onClose(int code, String reason) {
                sessionFuture.complete(null);
            }
        }).attach();
    }
}

