/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples.kubectl.equivalents;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodAttachEquivalent {
    private static final Logger logger = LoggerFactory.getLogger(PodAttachEquivalent.class);

    public static void main(String[] args) throws IOException {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            MyAttachListener listener = new MyAttachListener();
            ExecWatch watch = ((PodResource)((NonNamespaceOperation)client.pods().inNamespace("default")).withName("my-pod")).redirectingInput().writingOutput((OutputStream)System.out).writingError((OutputStream)System.err).withTTY().usingListener((ExecListener)listener).attach();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while (!listener.getSessionCompletionFuture().isDone()) {
                String input = reader.readLine();
                watch.getInput().write((input + "\n").getBytes(StandardCharsets.UTF_8));
                watch.getInput().flush();
            }
            watch.close();
        }
    }

    private static class MyAttachListener
    implements ExecListener {
        private final CompletableFuture<Void> sessionCompletionFuture = new CompletableFuture();

        private MyAttachListener() {
        }

        public void onOpen() {
            logger.info("Attached to the pod");
        }

        public void onFailure(Throwable t, ExecListener.Response failureResponse) {
            logger.warn("Error encountered", t);
            this.sessionCompletionFuture.complete(null);
        }

        public void onClose(int i, String s) {
            logger.info("Session closed");
            this.sessionCompletionFuture.complete(null);
        }

        @Generated
        public CompletableFuture<Void> getSessionCompletionFuture() {
            return this.sessionCompletionFuture;
        }
    }
}

