/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagBuilder;
import io.fabric8.openshift.api.model.ImageStreamTagFluent;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageStreamTagExample {
    private static final Logger logger = LoggerFactory.getLogger(ImageStreamTagExample.class);

    public static void main(String[] args) throws InterruptedException {
        try (OpenShiftClient client = (OpenShiftClient)new KubernetesClientBuilder().build().adapt(OpenShiftClient.class);){
            String project = Optional.ofNullable(client.getNamespace()).orElse("myproject");
            String isTagName = "bar1:1.0.12";
            ImageStreamTag isTag = (ImageStreamTag)((NonNamespaceOperation)client.imageStreamTags().inNamespace(project)).createOrReplace((Object)((ImageStreamTagBuilder)((ImageStreamTagFluent.TagNested)((TagReferenceFluent.FromNested)((TagReferenceFluent.FromNested)((ImageStreamTagBuilder)((ImageStreamTagFluent.MetadataNested)new ImageStreamTagBuilder().withNewMetadata().withName("bar1:1.0.12")).endMetadata()).withNewTag().withNewFrom().withKind("DockerImage")).withName("openshift/wildfly-81-centos7:latest")).endFrom()).endTag()).build());
            logger.info("Created ImageStreamTag: {}", (Object)isTag.getMetadata().getName());
            int limit = 0;
            while (((Resource)((NonNamespaceOperation)client.imageStreamTags().inNamespace(project)).withName("bar1:1.0.12")).get() == null && limit++ < 10) {
                TimeUnit.SECONDS.sleep(1L);
            }
            logger.info("ImageStreamTags in {}:", (Object)project);
            ((ImageStreamTagList)((NonNamespaceOperation)client.imageStreamTags().inNamespace(project)).list()).getItems().forEach(ist -> logger.info(" - {}", (Object)ist.getMetadata().getName()));
            boolean deletedIsTag = ((Resource)client.imageStreamTags().withName("bar1:1.0.12")).delete().size() == 1;
            logger.info("Deleted ImageStreamTag: {}", (Object)deletedIsTag);
        }
    }
}

