/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretExamples {
    private static final Logger logger = LoggerFactory.getLogger(SecretExamples.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
            logger.info("Using master with URL: {}", (Object)args[0]);
        }
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            String secretName = Utils.generateId().toString();
            String namespace = "default";
            logger.info("List of existent Secret:");
            ((SecretList)((NonNamespaceOperation)client.secrets().inNamespace("default")).list()).getItems().forEach(sc -> logger.info(" - {}", (Object)sc.getMetadata().getName()));
            logger.info("Creating new Secret");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("tls.crt", "YWFh");
            data.put("tls.key", "YmJi");
            Secret secret = ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(secretName)).endMetadata()).withType("kubernetes.io/tls")).withImmutable(Boolean.valueOf(false))).addToData(data)).build();
            Secret secretCreated = (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace("default")).resource((Object)secret)).create();
            logger.info("Newly created Secret details:\n{}", (Object)secretCreated);
            logger.info("Updated list of existent Secret:");
            ((SecretList)((NonNamespaceOperation)client.secrets().inNamespace("default")).list()).getItems().forEach(sc -> logger.info(" - {}", (Object)sc.getMetadata().getName()));
            logger.info("Updating {} Secret to add new label", (Object)secretName);
            Secret updatedSecret = (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace("default")).withName(secretName)).edit(s -> ((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder(s).editMetadata().addToLabels("testLabel", "testLabelValue")).endMetadata()).build());
            logger.info("Updated Secret details:\n{}", (Object)updatedSecret);
            client.resource((HasMetadata)secret).inNamespace("default").delete();
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

