/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceValidationFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.examples.crds.Dummy;
import io.fabric8.kubernetes.examples.crds.DummyList;
import io.fabric8.kubernetes.examples.crds.DummySpec;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRDExample {
    private static final Logger logger = LoggerFactory.getLogger(CRDExample.class);
    private static final boolean LOG_ROOT_PATHS = false;

    public static void main(String[] args) {
        boolean resourceNamespaced = true;
        String namespace = null;
        if (args.length > 0) {
            if ("--cluster".equals(args[0])) {
                resourceNamespaced = false;
            } else {
                namespace = args[0];
            }
        }
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            if (resourceNamespaced) {
                if (namespace == null) {
                    namespace = client.getNamespace();
                }
                if (namespace == null) {
                    System.err.println("No namespace specified and no default defined!");
                    return;
                }
                System.out.println("Using namespace: " + namespace);
            } else {
                System.out.println("Creating cluster scoped resource");
            }
            CustomResourceDefinitionList crds = (CustomResourceDefinitionList)client.apiextensions().v1().customResourceDefinitions().list();
            List crdsItems = crds.getItems();
            System.out.println("Found " + crdsItems.size() + " CRD(s)");
            CustomResourceDefinition dummyCRD = null;
            String dummyCRDName = CustomResource.getCRDName(Dummy.class);
            for (CustomResourceDefinition crd : crdsItems) {
                ObjectMeta metadata = crd.getMetadata();
                if (metadata == null) continue;
                String name = metadata.getName();
                System.out.println("    " + (String)name + " => " + metadata.getSelfLink());
                if (!dummyCRDName.equals(name)) continue;
                dummyCRD = crd;
            }
            if (dummyCRD != null) {
                System.out.println("Found CRD: " + dummyCRD.getMetadata().getSelfLink());
            } else {
                dummyCRD = ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.VersionsNested)((CustomResourceDefinitionVersionFluent.SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)CustomResourceDefinitionContext.v1CRDFromCustomResourceType(Dummy.class).editSpec().editVersion(Integer.valueOf(0)).withNewSchema().withNewOpenAPIV3Schema().withTitle("dummy")).withType("object")).addToRequired(new String[]{"spec"})).addToProperties("spec", ((JSONSchemaPropsBuilder)((JSONSchemaPropsBuilder)((JSONSchemaPropsBuilder)new JSONSchemaPropsBuilder().withType("object")).addToProperties("foo", ((JSONSchemaPropsBuilder)new JSONSchemaPropsBuilder().withType("string")).build())).addToProperties("bar", ((JSONSchemaPropsBuilder)new JSONSchemaPropsBuilder().withType("string")).build())).build())).endOpenAPIV3Schema()).endSchema()).endVersion()).endSpec()).build();
                client.apiextensions().v1().customResourceDefinitions().create((Object)dummyCRD);
                System.out.println("Created CRD " + dummyCRD.getMetadata().getName());
            }
            Thread.sleep(5000L);
            MixedOperation dummyClient = client.resources(Dummy.class, DummyList.class);
            if (resourceNamespaced) {
                dummyClient = (NonNamespaceOperation)dummyClient.inNamespace(namespace);
            }
            CustomResourceList dummyList = (CustomResourceList)dummyClient.list();
            List items = dummyList.getItems();
            System.out.println("  found " + items.size() + " dummies");
            for (Dummy item : items) {
                System.out.println("    " + (Object)((Object)item));
            }
            Dummy dummy = new Dummy();
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName("foo");
            dummy.setMetadata(metadata);
            DummySpec dummySpec = new DummySpec();
            Date now = new Date();
            dummySpec.setBar("beer: " + now);
            dummySpec.setFoo("cheese: " + now);
            dummy.setSpec(dummySpec);
            Dummy created = (Dummy)((Object)dummyClient.createOrReplace((Object)dummy));
            System.out.println("Upserted " + (Object)((Object)dummy));
            ((DummySpec)created.getSpec()).setBar("otherBar");
            dummyClient.createOrReplace((Object)created);
            System.out.println("Watching for changes to Dummies");
            dummyClient.withResourceVersion(created.getMetadata().getResourceVersion()).watch((Watcher)new Watcher<Dummy>(){

                public void eventReceived(Watcher.Action action, Dummy resource) {
                    System.out.println("==> " + action + " for " + (Object)((Object)resource));
                    if (resource.getSpec() == null) {
                        logger.error("No Spec for resource {}", (Object)resource);
                    }
                }

                public void onClose(WatcherException cause) {
                }
            });
            System.in.read();
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

