/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples.kubectl.equivalents;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodExecEquivalent {
    private static final Logger logger = LoggerFactory.getLogger(PodExecEquivalent.class);
    private static final CountDownLatch execLatch = new CountDownLatch(1);

    public static void main(String[] args) {
        try (DefaultKubernetesClient k8s = new DefaultKubernetesClient();){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream error = new ByteArrayOutputStream();
            ExecWatch execWatch = (ExecWatch)((Execable)((TtyExecErrorChannelable)((TtyExecErrorable)((PodResource)((NonNamespaceOperation)k8s.pods().inNamespace("default")).withName("my-pod")).writingOutput((Object)out)).writingError((Object)error)).usingListener((Object)new MyPodExecListener())).exec((Object[])new String[]{"ls", "/"});
            boolean latchTerminationStatus = execLatch.await(5L, TimeUnit.SECONDS);
            if (!latchTerminationStatus) {
                logger.warn("Latch could not terminate within specified time");
            }
            logger.info("Exec Output: {} ", (Object)out);
            execWatch.close();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted while waiting for the exec: {}", (Object)ie.getMessage());
        }
    }

    private static class MyPodExecListener
    implements ExecListener {
        private MyPodExecListener() {
        }

        public void onOpen() {
            logger.info("Shell was opened");
        }

        public void onFailure(Throwable t, ExecListener.Response failureResponse) {
            logger.info("Some error encountered");
            execLatch.countDown();
        }

        public void onClose(int i, String s) {
            logger.info("Shell Closing");
            execLatch.countDown();
        }
    }
}

