/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.openshift.client.OpenShiftClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptClient {
    private static final Logger logger = LoggerFactory.getLogger(AdaptClient.class);

    public static void main(String[] args) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            if (Boolean.FALSE.equals(client.isAdaptable(OpenShiftClient.class))) {
                logger.warn("Target cluster is not OpenShift compatible");
                return;
            }
            OpenShiftClient oClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            logger.info("Client adapted to OpenShiftClient: {}", (Object)oClient.getClass().getCanonicalName());
            logger.info("URL: {}", (Object)oClient.getOpenshiftUrl());
        }
    }
}

