/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.CronJob;
import io.fabric8.kubernetes.api.model.batch.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.CronJobFluent;
import io.fabric8.kubernetes.api.model.batch.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.JobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.JobTemplateSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronJobExample {
    private static final Logger logger = LoggerFactory.getLogger(CronJobExample.class);

    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        CronJobExample.log("Using master with url ", master);
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            String namespace = client.getNamespace();
            CronJob cronJob1 = ((CronJobBuilder)((CronJobFluent.SpecNested)((CronJobSpecFluent.JobTemplateNested)((JobTemplateSpecFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((CronJobFluent.SpecNested)((CronJobBuilder)((CronJobFluent.MetadataNested)((CronJobFluent.MetadataNested)((CronJobBuilder)new CronJobBuilder().withApiVersion("batch/v1beta1")).withNewMetadata().withName("hello")).withLabels(Collections.singletonMap("foo", "bar"))).endMetadata()).withNewSpec().withSchedule("*/1 * * * *")).withNewJobTemplate().withNewSpec().withNewTemplate().withNewSpec().addNewContainer().withName("hello")).withImage("busybox")).withArgs(new String[]{"/bin/sh", "-c", "date; echo Hello from Kubernetes"})).endContainer()).withRestartPolicy("OnFailure")).endSpec()).endTemplate()).endSpec()).endJobTemplate()).endSpec()).build();
            CronJobExample.log("Creating cron job from object");
            cronJob1 = (CronJob)((NonNamespaceOperation)client.batch().cronjobs().inNamespace(namespace)).create((Object)cronJob1);
            CronJobExample.log("Successfully created cronjob with name ", cronJob1.getMetadata().getName());
            CronJobExample.log("Watching over pod which would be created during cronjob execution...");
            CountDownLatch watchLatch = new CountDownLatch(1);
            try (Watch watch = ((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withLabel("job-name")).watch((Object)new Watcher<Pod>((KubernetesClient)client, namespace, watchLatch){
                final /* synthetic */ KubernetesClient val$client;
                final /* synthetic */ String val$namespace;
                final /* synthetic */ CountDownLatch val$watchLatch;
                {
                    this.val$client = kubernetesClient;
                    this.val$namespace = string;
                    this.val$watchLatch = countDownLatch;
                }

                public void eventReceived(Watcher.Action action, Pod aPod) {
                    CronJobExample.log(aPod.getMetadata().getName(), aPod.getStatus().getPhase());
                    if (aPod.getStatus().getPhase().equals("Succeeded")) {
                        CronJobExample.log("Logs -> ", ((PodResource)((NonNamespaceOperation)this.val$client.pods().inNamespace(this.val$namespace)).withName(aPod.getMetadata().getName())).getLog());
                        this.val$watchLatch.countDown();
                    }
                }

                public void onClose(WatcherException e) {
                }
            });){
                watchLatch.await(2L, TimeUnit.MINUTES);
            }
            catch (KubernetesClientException | InterruptedException e) {
                CronJobExample.log("Could not watch pod", e);
            }
        }
        catch (KubernetesClientException exception) {
            CronJobExample.log("An error occured while processing cronjobs:", exception.getMessage());
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

