/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchBuildConfigs {
    private static final Logger logger = LoggerFactory.getLogger(WatchBuildConfigs.class);

    public static void main(String[] args) {
        try (DefaultOpenShiftClient client = new DefaultOpenShiftClient();){
            String namespace = Optional.ofNullable(client.getNamespace()).orElse("myproject");
            logger.info("Watching BuildConfigs in namespace {}", (Object)namespace);
            try (Watch watchable = ((NonNamespaceOperation)client.buildConfigs().inNamespace(namespace)).watch((Object)new Watcher<BuildConfig>(){

                public void eventReceived(Watcher.Action action, BuildConfig resource) {
                    logger.info(">> Action: {} on BuildConfig {} with version: {}", new Object[]{action.name(), resource.getMetadata().getName(), resource.getApiVersion()});
                }

                public void onClose(WatcherException cause) {
                    logger.error("Error on Watcher (Closed): {}", (Object)cause.getMessage(), (Object)cause);
                }
            });){
                logger.info("Created watchable {}", (Object)watchable);
            }
        }
        catch (KubernetesClientException e) {
            logger.error("Failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

