/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesVersionExample {
    private static Logger logger = LoggerFactory.getLogger(KubernetesVersionExample.class);

    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            VersionInfo versionInfo = client.getVersion();
            KubernetesVersionExample.log("Version details of this Kubernetes cluster :-");
            KubernetesVersionExample.log("Major        : ", versionInfo.getMajor());
            KubernetesVersionExample.log("Minor        : ", versionInfo.getMinor());
            KubernetesVersionExample.log("GitVersion   : ", versionInfo.getGitVersion());
            KubernetesVersionExample.log("BuildDate    : ", versionInfo.getBuildDate());
            KubernetesVersionExample.log("GitTreeState : ", versionInfo.getGitTreeState());
            KubernetesVersionExample.log("Platform     : ", versionInfo.getPlatform());
            KubernetesVersionExample.log("GitVersion   : ", versionInfo.getGitVersion());
            KubernetesVersionExample.log("GoVersion    : ", versionInfo.getGoVersion());
            KubernetesVersionExample.log("GitCommit    : ", versionInfo.getGitCommit());
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

