/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchExample {
    private static final Logger logger = LoggerFactory.getLogger(WatchExample.class);

    public static void main(String[] args) throws InterruptedException {
        block29: {
            final CountDownLatch closeLatch = new CountDownLatch(1);
            Config config = new ConfigBuilder().build();
            try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
                try (Watch watch = ((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("default")).withName("test")).watch((Object)new Watcher<ReplicationController>(){

                    public void eventReceived(Watcher.Action action, ReplicationController resource) {
                        logger.info("{}: {}", (Object)action, (Object)resource.getMetadata().getResourceVersion());
                    }

                    public void onClose(WatcherException e) {
                        logger.debug("Watcher onClose");
                        if (e != null) {
                            logger.error(e.getMessage(), (Throwable)e);
                            closeLatch.countDown();
                        }
                    }
                });){
                    closeLatch.await(10L, TimeUnit.SECONDS);
                }
                catch (KubernetesClientException | InterruptedException e) {
                    logger.error("Could not watch resources", e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                Throwable[] suppressed = e.getSuppressed();
                if (suppressed == null) break block29;
                for (Throwable t : suppressed) {
                    logger.error(t.getMessage(), t);
                }
            }
        }
        Thread.sleep(60000L);
    }
}

