/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.api.model.storage.StorageClassBuilder;
import io.fabric8.kubernetes.api.model.storage.StorageClassFluent;
import io.fabric8.kubernetes.api.model.storage.StorageClassList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClassExamples {
    private static final Logger logger = LoggerFactory.getLogger(StorageClassExamples.class);

    public static void main(String[] args) {
        String master = "http://localhost:8080/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            StorageClassList storageClassList = (StorageClassList)client.storage().storageClasses().list();
            logger.info("List of storage classes: {}", (Object)storageClassList.toString());
            String name = UUID.randomUUID().toString();
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName(name);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("resturl", "http://192.168.10.100:8080");
            parameters.put("restuser", "");
            parameters.put("secretNamespace", "");
            parameters.put("secretName", "");
            parameters.put("key", "value1");
            StorageClass storageClass = ((StorageClassBuilder)((StorageClassBuilder)((StorageClassBuilder)((StorageClassBuilder)((StorageClassBuilder)new StorageClassBuilder().withApiVersion("storage.k8s.io/v1")).withKind("StorageClass")).withMetadata(metadata)).withParameters(parameters)).withProvisioner("k8s.io/minikube-hostpath")).build();
            storageClass = (StorageClass)client.storage().storageClasses().create((Object)storageClass);
            logger.info("Newly created storage class details: {}", (Object)storageClass.toString());
            storageClassList = (StorageClassList)client.storage().storageClasses().list();
            logger.info("List of storage classes: {}", (Object)storageClassList.toString());
            storageClass = (StorageClass)((Resource)client.storage().storageClasses().withName(name)).edit(s -> ((StorageClassBuilder)((StorageClassFluent.MetadataNested)new StorageClassBuilder(s).editMetadata().addToLabels("testLabel", "testLabelValue")).endMetadata()).build());
            storageClassList = (StorageClassList)client.storage().storageClasses().list();
            logger.info("List of storage classes: {}", (Object)storageClassList.toString());
            boolean isDeleteSuccessful = client.storage().storageClasses().delete((Object[])new StorageClass[]{storageClass});
            logger.info("Storage Class resource successfully deleted: {}", (Object)isDeleteSuccessful);
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

