/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwardExample {
    private static final Logger logger = LoggerFactory.getLogger(PortForwardExample.class);

    public static void main(String[] args) {
        String master = "https://localhost:8443";
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            String namespace = "default";
            PortForwardExample.log("namespace", namespace);
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).load(PortForwardExample.class.getResourceAsStream("/portforward-example-pod.yml"))).get();
            ((NonNamespaceOperation)client.pods().inNamespace(namespace)).create((Object)pod);
            PortForwardExample.log("Pod created");
            int containerPort = ((ContainerPort)((Container)pod.getSpec().getContainers().get(0)).getPorts().get(0)).getContainerPort();
            ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName("testpod")).waitUntilReady(10L, TimeUnit.SECONDS);
            LocalPortForward portForward = (LocalPortForward)((PodResource)((NonNamespaceOperation)client.pods().inNamespace("default")).withName("testpod")).portForward(containerPort, 8080);
            PortForwardExample.log("Port forwarded for 60 seconds at http://127.0.0.1:" + portForward.getLocalPort());
            PortForwardExample.log("Checking forwarded port:-");
            Response response = new OkHttpClient().newCall(new Request.Builder().get().url("http://127.0.0.1:" + portForward.getLocalPort()).build()).execute();
            PortForwardExample.log(response.body().string());
            Thread.sleep(60000L);
        }
        catch (Exception e) {
            PortForwardExample.log("Exception occurred: ", e.getMessage());
            e.printStackTrace();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

