/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitUntilReadyExample {
    private static Logger logger = LoggerFactory.getLogger(WaitUntilReadyExample.class);

    public static void main(String[] args) throws IOException, InterruptedException {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            Pod pod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.InitContainersNested)((PodSpecFluent.InitContainersNested)((PodSpecFluent.InitContainersNested)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("myapp-pod")).withLabels(Collections.singletonMap("app", "myapp-pod"))).endMetadata()).withNewSpec().addNewContainer().withName("myapp-container")).withImage("busybox:1.28")).withCommand(new String[]{"sh", "-c", "echo The app is running!; sleep 10"})).endContainer()).addNewInitContainer().withName("init-myservice")).withImage("busybox:1.28")).withCommand(new String[]{"sh", "-c", "echo inititalizing...; sleep 5"})).endInitContainer()).endSpec()).build();
            String namespace = "default";
            pod = (Pod)((NonNamespaceOperation)client.pods().inNamespace(namespace)).create((Object[])new Pod[]{pod});
            WaitUntilReadyExample.log("Pod created, waiting for it to get ready");
            ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)client.resource((HasMetadata)pod).inNamespace(namespace)).waitUntilReady(10L, TimeUnit.SECONDS);
            WaitUntilReadyExample.log("Pod is ready now.");
            LogWatch watch = (LogWatch)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(pod.getMetadata().getName())).watchLog((OutputStream)System.out);
            watch.wait(10L);
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

