/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.NodeSelectorFluent;
import io.fabric8.kubernetes.api.model.NodeSelectorRequirementBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.VolumeNodeAffinityFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.examples.PodDisruptionBudgetExample;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentVolumeExample {
    private static final Logger logger = LoggerFactory.getLogger(PodDisruptionBudgetExample.class);

    public static void main(String[] args) throws InterruptedException {
        String master = "https://192.168.99.100:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        PersistentVolumeExample.log("Using master with url ", master);
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            PersistentVolumeExample.log("Creating persistent volume object");
            PersistentVolume pv = ((PersistentVolumeBuilder)((PersistentVolumeFluent.SpecNested)((PersistentVolumeSpecFluent.NodeAffinityNested)((VolumeNodeAffinityFluent.RequiredNested)((NodeSelectorFluent.NodeSelectorTermsNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeSpecFluent.LocalNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeBuilder)((PersistentVolumeFluent.MetadataNested)new PersistentVolumeBuilder().withNewMetadata().withName("example-local-pv")).endMetadata()).withNewSpec().addToCapacity(Collections.singletonMap("storage", new Quantity("500Gi")))).withAccessModes(new String[]{"ReadWriteOnce"})).withPersistentVolumeReclaimPolicy("Retain")).withStorageClassName("local-storage")).withNewLocal().withPath("/mnt/disks/vol1")).endLocal()).withNewNodeAffinity().withNewRequired().addNewNodeSelectorTerm().withMatchExpressions(Arrays.asList(((NodeSelectorRequirementBuilder)((NodeSelectorRequirementBuilder)((NodeSelectorRequirementBuilder)new NodeSelectorRequirementBuilder().withKey("kubernetes.io/hostname")).withOperator("In")).withValues(new String[]{"my-node"})).build()))).endNodeSelectorTerm()).endRequired()).endNodeAffinity()).endSpec()).build();
            client.persistentVolumes().create((Object[])new PersistentVolume[]{pv});
            PersistentVolumeExample.log("Successfully created Persistent Volume object");
        }
        catch (KubernetesClientException e) {
            PersistentVolumeExample.log("Could not create resource", e.getMessage());
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

