/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.kubernetes.api.model.batch.JobSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExample {
    private static final Logger logger = LoggerFactory.getLogger(JobExample.class);

    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            String namespace = "default";
            Job job = ((JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobBuilder)new JobBuilder().withApiVersion("batch/v1")).withNewMetadata().withName("pi")).withLabels(Collections.singletonMap("label1", "maximum-length-of-63-characters"))).withAnnotations(Collections.singletonMap("annotation1", "some-very-long-annotation"))).endMetadata()).withNewSpec().withNewTemplate().withNewSpec().addNewContainer().withName("pi")).withImage("perl")).withArgs(new String[]{"perl", "-Mbignum=bpi", "-wle", "print bpi(2000)"})).endContainer()).withRestartPolicy("Never")).endSpec()).endTemplate()).endSpec()).build();
            logger.info("Creating job pi.");
            ((NonNamespaceOperation)client.batch().jobs().inNamespace("default")).create((Object[])new Job[]{job});
            logger.info("Job pi is created, waiting for result...");
            CountDownLatch watchLatch = new CountDownLatch(1);
            try (Watch ignored = (Watch)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace("default")).withLabel("job-name")).watch((Object)new Watcher<Pod>((KubernetesClient)client, watchLatch, job){
                final /* synthetic */ KubernetesClient val$client;
                final /* synthetic */ CountDownLatch val$watchLatch;
                final /* synthetic */ Job val$job;
                {
                    this.val$client = kubernetesClient;
                    this.val$watchLatch = countDownLatch;
                    this.val$job = job;
                }

                public void eventReceived(Watcher.Action action, Pod pod) {
                    if (pod.getStatus().getPhase().equals("Succeeded")) {
                        logger.info("Job pi is completed!");
                        logger.info((String)((PodResource)((NonNamespaceOperation)this.val$client.pods().inNamespace("default")).withName(pod.getMetadata().getName())).getLog());
                        this.val$watchLatch.countDown();
                    }
                }

                public void onClose(KubernetesClientException e) {
                    logger.info("Cleaning up job pi.");
                    ((NonNamespaceOperation)this.val$client.batch().jobs().inNamespace("default")).delete((Object[])new Job[]{this.val$job});
                }
            });){
                watchLatch.await(2L, TimeUnit.MINUTES);
            }
            catch (KubernetesClientException | InterruptedException e) {
                logger.error("Could not watch pod", e);
            }
        }
        catch (KubernetesClientException e) {
            logger.error("Unable to create job", (Throwable)e);
        }
    }
}

