/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.Callback;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.Response;

public class ExecLoopExample {
    public static void main(String[] args) throws InterruptedException, IOException {
        String master = "https://localhost:8443/";
        String podName = null;
        if (args.length >= 2) {
            master = args[0];
            podName = args[1];
        }
        if (args.length == 1) {
            podName = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(20);
        try (DefaultOpenShiftClient client = new DefaultOpenShiftClient(config);){
            for (int i = 0; i < 10; ++i) {
                ExecWatch watch = null;
                InputStreamPumper pump = null;
                final CountDownLatch latch = new CountDownLatch(1);
                watch = (ExecWatch)((Execable)((TtyExecErrorable)((PodResource)client.pods().withName(podName)).redirectingOutput()).usingListener((Object)new ExecListener(){

                    public void onOpen(Response response) {
                    }

                    public void onFailure(Throwable t, Response response) {
                        latch.countDown();
                    }

                    public void onClose(int code, String reason) {
                        latch.countDown();
                    }
                })).exec((Object[])new String[]{"date"});
                pump = new InputStreamPumper(watch.getOutput(), (Callback)new SystemOutCallback());
                executorService.submit((Runnable)pump);
                Future<String> outPumpFuture = executorService.submit((Runnable)pump, "Done");
                executorService.scheduleAtFixedRate(new FutureChecker("Pump " + (i + 1), outPumpFuture), 0L, 2L, TimeUnit.SECONDS);
                latch.await(5L, TimeUnit.SECONDS);
                watch.close();
                pump.close();
                System.out.println("i=" + i);
            }
        }
        executorService.shutdown();
        System.out.println("Done.");
    }

    private static class SystemOutCallback
    implements Callback<byte[]> {
        private SystemOutCallback() {
        }

        public void call(byte[] data) {
            System.out.print(new String(data));
        }
    }

    private static class FutureChecker
    implements Runnable {
        private final String name;
        private final Future<String> future;

        private FutureChecker(String name, Future<String> future) {
            this.name = name;
            this.future = future;
        }

        @Override
        public void run() {
            if (!this.future.isDone()) {
                System.out.println("Future:[" + this.name + "] is not done yet");
            }
        }
    }
}

