/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.client.DefaultOpenShiftClient;

public class WatchBuildConfigs {
    public static void main(String[] args) {
        try {
            DefaultOpenShiftClient client = new DefaultOpenShiftClient();
            String namespace = client.getNamespace();
            System.out.println("Watching BuildConfigs in namespace " + namespace);
            try (Watch watchable = (Watch)((NonNamespaceOperation)client.buildConfigs().inNamespace(namespace)).watch((Object)new Watcher<BuildConfig>(){

                public void eventReceived(Watcher.Action action, BuildConfig resource) {
                    System.out.println(">> Action: " + action + " on BuildConfig " + resource.getMetadata().getName() + " with version: " + resource.getApiVersion());
                }

                public void onClose(KubernetesClientException cause) {
                    System.out.println("Watch Closed: " + cause);
                    if (cause != null) {
                        cause.printStackTrace();
                    }
                }
            });){
                System.out.println("Created watchable " + watchable);
            }
        }
        catch (KubernetesClientException e) {
            System.out.println("Failed: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }
}

