/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;

public class SerialExecutor
implements Executor {
    final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    final Executor executor;
    Runnable active;

    public SerialExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public synchronized void execute(Runnable r) {
        this.tasks.offer(() -> {
            try {
                r.run();
            }
            finally {
                this.scheduleNext();
            }
        });
        if (this.active == null) {
            this.scheduleNext();
        }
    }

    protected synchronized void scheduleNext() {
        this.active = this.tasks.poll();
        if (this.active != null) {
            this.executor.execute(this.active);
        }
    }
}

