/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.utils.Pluralize;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Singular;
import io.fabric8.kubernetes.model.annotation.Version;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
public abstract class CustomResource<S, T>
implements HasMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(CustomResource.class);
    public static final String NAMESPACE_SCOPE = "Namespaced";
    public static final String CLUSTER_SCOPE = "Cluster";
    private ObjectMeta metadata = new ObjectMeta();
    @JsonProperty(value="spec")
    protected S spec;
    @JsonProperty(value="status")
    protected T status;
    private final String singular;
    private final String crdName;
    private final String kind;
    private final String apiVersion;
    private final String scope;
    private final String plural;
    private final boolean served;
    private final boolean storage;
    private static final String TYPE_NAME = CustomResource.class.getTypeName();
    private static final String VOID_TYPE_NAME = Void.class.getTypeName();
    private static final Map<String, Instantiator> instantiators = new ConcurrentHashMap<String, Instantiator>();

    public CustomResource() {
        String version = super.getApiVersion();
        Class<?> clazz = this.getClass();
        if (Utils.isNullOrEmpty(version)) {
            throw new IllegalArgumentException(clazz.getName() + " CustomResource must provide an API version using @" + Group.class.getName() + " and @" + Version.class.getName() + " annotations");
        }
        this.apiVersion = version;
        this.kind = super.getKind();
        this.scope = this instanceof Namespaced ? NAMESPACE_SCOPE : CLUSTER_SCOPE;
        this.singular = CustomResource.getSingular(clazz);
        this.plural = CustomResource.getPlural(clazz);
        this.crdName = CustomResource.getCRDName(clazz);
        this.served = CustomResource.getServed(clazz);
        this.storage = CustomResource.getStorage(clazz);
        this.spec = this.initSpec();
        this.status = this.initStatus();
    }

    public static boolean getServed(Class<? extends CustomResource> clazz) {
        Version annotation = clazz.getAnnotation(Version.class);
        return annotation == null || annotation.served();
    }

    public static boolean getStorage(Class<? extends CustomResource> clazz) {
        Version annotation = clazz.getAnnotation(Version.class);
        return annotation == null || annotation.storage();
    }

    protected S initSpec() {
        return (S)this.genericInit(0);
    }

    protected T initStatus() {
        return (T)this.genericInit(1);
    }

    public String toString() {
        return "CustomResource{kind='" + this.getKind() + '\'' + ", apiVersion='" + this.getApiVersion() + '\'' + ", metadata=" + this.metadata + ", spec=" + this.spec + ", status=" + this.status + '}';
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String version) {
        LOG.debug("Calling CustomResource#setApiVersion doesn't do anything because the API version is computed and shouldn't be changed");
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        LOG.debug("Calling CustomResource#setKind doesn't do anything because the Kind is computed and shouldn't be changed");
    }

    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public static String getPlural(Class<? extends HasMetadata> clazz) {
        Plural fromAnnotation = clazz.getAnnotation(Plural.class);
        return fromAnnotation != null ? fromAnnotation.value().toLowerCase(Locale.ROOT) : Pluralize.toPlural(CustomResource.getSingular(clazz));
    }

    @JsonIgnore
    public String getPlural() {
        return this.plural;
    }

    public static String getSingular(Class<? extends HasMetadata> clazz) {
        Singular fromAnnotation = clazz.getAnnotation(Singular.class);
        return (fromAnnotation != null ? fromAnnotation.value() : HasMetadata.getKind(clazz)).toLowerCase(Locale.ROOT);
    }

    @JsonIgnore
    public String getSingular() {
        return this.singular;
    }

    public static String getCRDName(Class<? extends CustomResource> clazz) {
        return CustomResource.getPlural(clazz) + "." + HasMetadata.getGroup(clazz);
    }

    @JsonIgnore
    public String getCRDName() {
        return this.crdName;
    }

    @JsonIgnore
    public String getScope() {
        return this.scope;
    }

    @JsonIgnore
    public String getGroup() {
        return HasMetadata.getGroup(this.getClass());
    }

    @JsonIgnore
    public String getVersion() {
        return HasMetadata.getVersion(this.getClass());
    }

    @JsonIgnore
    public boolean isServed() {
        return this.served;
    }

    @JsonIgnore
    public boolean isStorage() {
        return this.storage;
    }

    public S getSpec() {
        return this.spec;
    }

    public void setSpec(S spec) {
        this.spec = spec;
    }

    public T getStatus() {
        return this.status;
    }

    public void setStatus(T status) {
        this.status = status;
    }

    private Instantiator getInstantiator(int genericTypeIndex) throws Exception {
        String key = CustomResource.getKey(this.getClass(), genericTypeIndex);
        Instantiator instantiator = instantiators.get(key);
        if (instantiator == null) {
            instantiator = Instantiator.NULL;
            Type genericSuperclass = this.getClass().getGenericSuperclass();
            String typeName = genericSuperclass.getTypeName();
            while (!TYPE_NAME.equals(typeName) && !(genericSuperclass instanceof ParameterizedType)) {
                genericSuperclass = ((Class)genericSuperclass).getGenericSuperclass();
                typeName = genericSuperclass.getTypeName();
            }
            if (genericSuperclass instanceof ParameterizedType) {
                Type[] types = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
                if (types.length != 2) {
                    throw new IllegalArgumentException("Automatic instantiation of Spec and Status only works for CustomResource implementations parameterized with both types, consider overriding initSpec and/or initStatus");
                }
                String className = types[genericTypeIndex].getTypeName();
                if (!VOID_TYPE_NAME.equals(className)) {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                    if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                        throw new IllegalArgumentException("Cannot instantiate interface/abstract type " + className);
                    }
                    instantiator = () -> {
                        Constructor constructor;
                        try {
                            constructor = clazz.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                        }
                        catch (NoSuchMethodException | SecurityException e) {
                            throw new IllegalArgumentException("Cannot find a no-arg constructor for " + className);
                        }
                        return constructor.newInstance(new Object[0]);
                    };
                }
            }
            instantiators.put(key, instantiator);
        }
        return instantiator;
    }

    private Object genericInit(int genericTypeIndex) {
        try {
            return this.getInstantiator(genericTypeIndex).instantiate();
        }
        catch (Exception e) {
            String fieldName = genericTypeIndex == 0 ? "Spec" : "Status";
            throw new IllegalArgumentException("Cannot instantiate " + fieldName + ", consider overriding init" + fieldName + ": " + e.getMessage(), e);
        }
    }

    private static final String getKey(Class<? extends CustomResource> clazz, int genericTypeIndex) {
        return clazz.getCanonicalName() + "_" + genericTypeIndex;
    }

    @FunctionalInterface
    private static interface Instantiator {
        public static final Instantiator NULL = () -> null;

        public Object instantiate() throws Exception;
    }
}

