/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.handlers.storage.v1beta1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINode;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.internal.storage.v1beta1.CSINodeOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class CSINodeHandler
implements ResourceHandler<CSINode, CSINodeBuilder> {
    @Override
    public String getKind() {
        return CSINode.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "storage.k8s.io/v1beta1";
    }

    @Override
    public CSINode create(OkHttpClient client, Config config, String namespace, CSINode item) {
        return (CSINode)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new CSINode[0]);
    }

    @Override
    public CSINode replace(OkHttpClient client, Config config, String namespace, CSINode item) {
        return ((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public CSINode reload(OkHttpClient client, Config config, String namespace, CSINode item) {
        return (CSINode)((Gettable)((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public CSINodeBuilder edit(CSINode item) {
        return new CSINodeBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, CSINode item) {
        return new CSINodeOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, CSINode item, Watcher<CSINode> watcher) {
        return ((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, CSINode item, String resourceVersion, Watcher<CSINode> watcher) {
        return ((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, CSINode item, ListOptions options, Watcher<CSINode> watcher) {
        return ((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public CSINode waitUntilReady(OkHttpClient client, Config config, String namespace, CSINode item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (CSINode)((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public CSINode waitUntilCondition(OkHttpClient client, Config config, String namespace, CSINode item, Predicate<CSINode> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (CSINode)((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

