/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.apps.ControllerRevision;
import io.fabric8.kubernetes.api.model.apps.ControllerRevisionList;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.ControllerRevisionOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.StatefulSetRollingUpdater;
import io.fabric8.kubernetes.client.utils.PodOperationUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class StatefulSetOperationsImpl
extends RollableScalableResourceOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>>
implements TimeoutImageEditReplacePatchable<StatefulSet> {
    private Integer podLogWaitTimeout;

    public StatefulSetOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public StatefulSetOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
    }

    public StatefulSetOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("statefulsets"));
        this.type = StatefulSet.class;
        this.listType = StatefulSetList.class;
    }

    private StatefulSetOperationsImpl(RollingOperationContext context, Integer podLogWaitTimeout) {
        this(context);
        this.podLogWaitTimeout = podLogWaitTimeout;
    }

    public StatefulSetOperationsImpl newInstance(OperationContext context) {
        return new StatefulSetOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public StatefulSet withReplicas(int count) {
        return this.cascading(false).accept((T s) -> s.getSpec().setReplicas(Integer.valueOf(count)));
    }

    @Override
    public RollingUpdater<StatefulSet, StatefulSetList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new StatefulSetRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public int getCurrentReplicas(StatefulSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(StatefulSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(StatefulSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public StatefulSetOperationsImpl rolling() {
        return new StatefulSetOperationsImpl(((RollingOperationContext)this.context).withRolling(true));
    }

    @Override
    public StatefulSet updateImage(Map<String, String> containerToImageMap) {
        StatefulSet statefulSet = (StatefulSet)this.get();
        if (statefulSet == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (statefulSet.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        List containers = statefulSet.getSpec().getTemplate().getSpec().getContainers();
        for (Container container : containers) {
            if (!containerToImageMap.containsKey(container.getName())) continue;
            container.setImage(containerToImageMap.get(container.getName()));
        }
        statefulSet.getSpec().getTemplate().getSpec().setContainers(containers);
        return this.sendPatchedObject(this.get(), statefulSet);
    }

    @Override
    public StatefulSet updateImage(String image) {
        StatefulSet oldRC = (StatefulSet)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing StatefulSet doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container container = (Container)oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next();
        return this.updateImage(Collections.singletonMap(container.getName(), image));
    }

    @Override
    public ImageEditReplacePatchable<StatefulSet> withTimeout(long timeout, TimeUnit unit) {
        return new StatefulSetOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(unit.toMillis(timeout)).withRollingTimeUnit(TimeUnit.MILLISECONDS));
    }

    @Override
    public ImageEditReplacePatchable<StatefulSet> withTimeoutInMillis(long timeoutInMillis) {
        return new StatefulSetOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(timeoutInMillis));
    }

    @Override
    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of StatefulSets");
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource<Pod>> podOperationList = this.doGetLog(isPretty);
        for (PodResource<Pod> podOperation : podOperationList) {
            stringBuilder.append(podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource<Pod>> doGetLog(boolean isPretty) {
        StatefulSet statefulSet = (StatefulSet)this.fromServer().get();
        return PodOperationUtil.getPodOperationsForController(this.context, statefulSet.getMetadata().getUid(), StatefulSetOperationsImpl.getStatefulSetSelectorLabels(statefulSet), isPretty, this.podLogWaitTimeout);
    }

    @Override
    public Reader getLogReader() {
        List<PodResource<Pod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Reading logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        List<PodResource<Pod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Watching logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return (LogWatch)podResources.get(0).watchLog(out);
        }
        return null;
    }

    @Override
    public Loggable<LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        return new StatefulSetOperationsImpl((RollingOperationContext)this.context, logWaitTimeout);
    }

    @Override
    public StatefulSet pause() {
        return this.sendPatchedStatefulSet(RollingUpdater.requestPayLoadForRolloutPause());
    }

    @Override
    public StatefulSet resume() {
        return this.sendPatchedStatefulSet(RollingUpdater.requestPayLoadForRolloutResume());
    }

    @Override
    public StatefulSet restart() {
        return this.sendPatchedStatefulSet(RollingUpdater.requestPayLoadForRolloutRestart());
    }

    @Override
    public StatefulSet undo() {
        List controllerRevisions = this.getControllerRevisionListForStatefulSet((StatefulSet)this.get()).getItems();
        if (controllerRevisions.size() < 2) {
            throw new IllegalStateException("No revision to rollback to!");
        }
        controllerRevisions.sort((o1, o2) -> {
            Long revision2 = o2.getRevision();
            Long revision1 = o1.getRevision();
            if (revision1 != null && revision2 != null) {
                return revision2.intValue() - revision1.intValue();
            }
            if (revision1 != null) {
                return revision1.intValue();
            }
            if (revision2 != null) {
                return revision2.intValue();
            }
            return 0;
        });
        ControllerRevision previousControllerRevision = (ControllerRevision)controllerRevisions.get(1);
        return this.sendPatchedStatefulSetData(previousControllerRevision.getData());
    }

    private StatefulSet sendPatchedStatefulSet(Map<String, Object> patchedUpdate) {
        StatefulSet oldStatefulSet = (StatefulSet)this.get();
        try {
            return this.handlePatch(oldStatefulSet, patchedUpdate);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private StatefulSet sendPatchedStatefulSetData(HasMetadata patchedUpdate) {
        return this.sendPatchedStatefulSet(StatefulSetOperationsImpl.getObjectValueAsMap(patchedUpdate));
    }

    private ControllerRevisionList getControllerRevisionListForStatefulSet(StatefulSet statefulSet) {
        return (ControllerRevisionList)new ControllerRevisionOperationsImpl(this.client, this.config, this.getNamespace()).withLabels(statefulSet.getSpec().getSelector().getMatchLabels()).list();
    }

    static Map<String, String> getStatefulSetSelectorLabels(StatefulSet statefulSet) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (statefulSet != null && statefulSet.getSpec() != null && statefulSet.getSpec().getTemplate() != null && statefulSet.getSpec().getTemplate().getMetadata() != null) {
            labels.putAll(statefulSet.getSpec().getTemplate().getMetadata().getLabels());
        }
        return labels;
    }
}

