/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RawCustomResourceOperationsImpl
extends OperationSupport {
    private OkHttpClient client;
    private Config config;
    private CustomResourceDefinitionContext customResourceDefinition;
    private ObjectMapper objectMapper;

    public RawCustomResourceOperationsImpl(OkHttpClient client, Config config, CustomResourceDefinitionContext customResourceDefinition) {
        this.client = client;
        this.config = config;
        this.customResourceDefinition = customResourceDefinition;
        this.objectMapper = new ObjectMapper();
    }

    public Map<String, Object> load(InputStream fileInputStream) throws IOException {
        return this.convertJsonStringToMap(IOHelpers.readFully(fileInputStream));
    }

    public Map<String, Object> load(String objectAsJsonString) throws IOException {
        return this.convertJsonStringToMap(objectAsJsonString);
    }

    public Map<String, Object> create(String objectAsString) throws IOException {
        return this.validateAndSubmitRequest(null, null, objectAsString, HttpCallMethod.POST);
    }

    public Map<String, Object> create(Map<String, Object> object) throws KubernetesClientException, IOException {
        return this.validateAndSubmitRequest(null, null, this.objectMapper.writeValueAsString(object), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, String objectAsString) throws KubernetesClientException, IOException {
        return this.validateAndSubmitRequest(namespace, null, objectAsString, HttpCallMethod.POST);
    }

    public Map<String, Object> create(InputStream objectAsStream) throws KubernetesClientException, IOException {
        return this.validateAndSubmitRequest(null, null, IOHelpers.readFully(objectAsStream), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, InputStream objectAsStream) throws KubernetesClientException, IOException {
        return this.validateAndSubmitRequest(namespace, null, IOHelpers.readFully(objectAsStream), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, Map<String, Object> object) throws KubernetesClientException, IOException {
        return this.validateAndSubmitRequest(namespace, null, this.objectMapper.writeValueAsString(object), HttpCallMethod.POST);
    }

    public Map<String, Object> createOrReplace(String objectAsString) throws IOException {
        return this.createOrReplaceJsonStringObject(null, objectAsString);
    }

    public Map<String, Object> createOrReplace(Map<String, Object> customResourceObject) throws IOException {
        return this.createOrReplace(this.objectMapper.writeValueAsString(customResourceObject));
    }

    public Map<String, Object> createOrReplace(InputStream inputStream) throws IOException {
        return this.createOrReplace(IOHelpers.readFully(inputStream));
    }

    public Map<String, Object> createOrReplace(String namespace, String objectAsString) throws IOException {
        return this.createOrReplaceJsonStringObject(namespace, objectAsString);
    }

    public Map<String, Object> createOrReplace(String namespace, Map<String, Object> customResourceObject) throws IOException {
        return this.createOrReplace(namespace, this.objectMapper.writeValueAsString(customResourceObject));
    }

    public Map<String, Object> createOrReplace(String namespace, InputStream objectAsString) throws IOException {
        return this.createOrReplace(namespace, IOHelpers.readFully(objectAsString));
    }

    public Map<String, Object> edit(String name, Map<String, Object> object) throws IOException {
        return this.validateAndSubmitRequest(null, name, this.objectMapper.writeValueAsString(object), HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String name, String objectAsString) throws IOException {
        return this.validateAndSubmitRequest(null, name, objectAsString, HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String namespace, String name, Map<String, Object> object) throws IOException {
        return this.validateAndSubmitRequest(namespace, name, this.objectMapper.writeValueAsString(object), HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String namespace, String name, String objectAsString) throws IOException {
        return this.validateAndSubmitRequest(namespace, name, objectAsString, HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String name, InputStream objectAsStream) throws IOException, KubernetesClientException {
        return this.validateAndSubmitRequest(null, name, IOHelpers.readFully(objectAsStream), HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String namespace, String name, InputStream objectAsStream) throws IOException, KubernetesClientException {
        return this.validateAndSubmitRequest(namespace, name, IOHelpers.readFully(objectAsStream), HttpCallMethod.PUT);
    }

    public Map<String, Object> get(String name) {
        return this.makeCall(this.fetchUrl(null, null) + name, null, HttpCallMethod.GET);
    }

    public Map<String, Object> get(String namespace, String name) {
        return this.makeCall(this.fetchUrl(namespace, null) + name, null, HttpCallMethod.GET);
    }

    public Map<String, Object> list() {
        return this.makeCall(this.fetchUrl(null, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> list(String namespace) {
        return this.makeCall(this.fetchUrl(namespace, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> list(String namespace, Map<String, String> labels) {
        return this.makeCall(this.fetchUrl(namespace, labels), null, HttpCallMethod.GET);
    }

    public Map<String, Object> delete(String namespace) {
        return this.makeCall(this.fetchUrl(namespace, null), null, HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, String name) {
        return this.makeCall(this.fetchUrl(namespace, null) + name, null, HttpCallMethod.DELETE);
    }

    private Map<String, Object> createOrReplaceJsonStringObject(String namespace, String objectAsString) throws IOException {
        Map<String, Object> ret;
        try {
            ret = namespace != null ? this.create(namespace, objectAsString) : this.create(objectAsString);
        }
        catch (KubernetesClientException exception) {
            try {
                Map<String, Object> objectMap = this.load(objectAsString);
                String name = ((Map)objectMap.get("metadata")).get("name").toString();
                ret = namespace != null ? this.edit(namespace, name, objectAsString) : this.edit(name, objectAsString);
            }
            catch (NullPointerException nullPointerException) {
                throw KubernetesClientException.launderThrowable(new IllegalStateException("Invalid json string provided."));
            }
        }
        return ret;
    }

    private Map<String, Object> convertJsonStringToMap(String objectAsString) throws IOException {
        HashMap retVal = null;
        retVal = IOHelpers.isJSONValid(objectAsString) ? (HashMap)this.objectMapper.readValue(objectAsString, HashMap.class) : (HashMap)this.objectMapper.readValue(IOHelpers.convertYamlToJson(objectAsString), HashMap.class);
        return retVal;
    }

    private String fetchUrl(String namespace, Map<String, String> labels) {
        StringBuilder urlBuilder = new StringBuilder(this.config.getMasterUrl());
        urlBuilder.append("apis/").append(this.customResourceDefinition.getGroup()).append("/").append(this.customResourceDefinition.getVersion()).append("/");
        if (this.customResourceDefinition.getScope().equals("Namespaced") && namespace != null) {
            urlBuilder.append("namespaces/").append(namespace).append("/");
        }
        urlBuilder.append(this.customResourceDefinition.getPlural()).append("/");
        if (labels != null) {
            urlBuilder.deleteCharAt(urlBuilder.lastIndexOf("/"));
            urlBuilder.append("?labelSelector").append("=").append(this.getLabelsQueryParam(labels));
        }
        return urlBuilder.toString();
    }

    private String getLabelsQueryParam(Map<String, String> labels) {
        StringBuilder labelQueryBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            if (labelQueryBuilder.length() > 0) {
                labelQueryBuilder.append(",");
            }
            labelQueryBuilder.append(entry.getKey()).append(Utils.toUrlEncoded("=")).append(entry.getValue());
        }
        return labelQueryBuilder.toString();
    }

    private Map<String, Object> makeCall(String url, String body, HttpCallMethod callMethod) throws RuntimeException {
        try {
            Response response = body == null ? this.client.newCall(this.getRequest(url, callMethod)).execute() : this.client.newCall(this.getRequest(url, body, callMethod)).execute();
            if (response.code() != 404 && response.code() != 500 && response.code() != 400) {
                return (Map)this.objectMapper.readValue(response.body().string(), HashMap.class);
            }
            if (response.body() != null) {
                throw new KubernetesClientException(response.body().string());
            }
            response.close();
            throw new KubernetesClientException(response.message());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private Map<String, Object> validateAndSubmitRequest(String namespace, String name, String objectAsString, HttpCallMethod httpCallMethod) throws IOException {
        if (IOHelpers.isJSONValid(objectAsString)) {
            return this.makeCall(this.fetchUrl(namespace, null) + (name != null ? name : ""), objectAsString, httpCallMethod);
        }
        return this.makeCall(this.fetchUrl(namespace, null) + (name != null ? name : ""), IOHelpers.convertYamlToJson(objectAsString), httpCallMethod);
    }

    private Request getRequest(String url, HttpCallMethod httpCallMethod) {
        Request.Builder requestBuilder = new Request.Builder();
        switch (httpCallMethod) {
            case GET: {
                requestBuilder.get().url(url);
                break;
            }
            case DELETE: {
                requestBuilder.delete().url(url);
            }
        }
        return requestBuilder.build();
    }

    private Request getRequest(String url, String body, HttpCallMethod httpCallMethod) {
        Request.Builder requestBuilder = new Request.Builder();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body);
        switch (httpCallMethod) {
            case POST: {
                return requestBuilder.post(requestBody).url(url).build();
            }
            case PUT: {
                return requestBuilder.put(requestBody).url(url).build();
            }
        }
        return requestBuilder.build();
    }

    private static enum HttpCallMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

