/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.ReplicationControllerRollingUpdater;
import io.fabric8.kubernetes.client.utils.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ReplicationControllerOperationsImpl
extends RollableScalableResourceOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>>
implements TimeoutImageEditReplacePatchable<ReplicationController, ReplicationController, DoneableReplicationController> {
    private Integer podLogWaitTimeout;

    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
    }

    public ReplicationControllerOperationsImpl(RollingOperationContext context) {
        super(context.withPlural("replicationcontrollers"));
        this.type = ReplicationController.class;
        this.listType = ReplicationControllerList.class;
        this.doneableType = DoneableReplicationController.class;
    }

    private ReplicationControllerOperationsImpl(RollingOperationContext context, Integer podLogWaitTimeout) {
        this(context);
        this.podLogWaitTimeout = podLogWaitTimeout;
    }

    public ReplicationControllerOperationsImpl newInstance(OperationContext context) {
        return new ReplicationControllerOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public RollableScalableResource<ReplicationController, DoneableReplicationController> load(InputStream is) {
        ReplicationController item = ReplicationControllerOperationsImpl.unmarshal(is, ReplicationController.class);
        return new ReplicationControllerOperationsImpl((RollingOperationContext)this.context.withItem(item));
    }

    @Override
    public ReplicationController withReplicas(int count) {
        return ((DoneableReplicationController)((ReplicationControllerFluent.SpecNested)((DoneableReplicationController)this.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(count))).endSpec()).done();
    }

    @Override
    public RollingUpdater<ReplicationController, ReplicationControllerList, DoneableReplicationController> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicationControllerRollingUpdater(this.client, this.config, this.namespace, rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public int getCurrentReplicas(ReplicationController current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(ReplicationController item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(ReplicationController current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public ReplicationController updateImage(Map<String, String> containerToImageMap) {
        ReplicationController replicationController = (ReplicationController)this.get();
        if (replicationController == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (replicationController.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        List containers = replicationController.getSpec().getTemplate().getSpec().getContainers();
        for (Container container : containers) {
            if (!containerToImageMap.containsKey(container.getName())) continue;
            container.setImage(containerToImageMap.get(container.getName()));
        }
        replicationController.getSpec().getTemplate().getSpec().setContainers(containers);
        return this.sendPatchedObject(this.get(), replicationController);
    }

    @Override
    public ReplicationController updateImage(String image) {
        ReplicationController oldRC = (ReplicationController)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replication controller doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container container = (Container)oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next();
        return this.updateImage(Collections.singletonMap(container.getName(), image));
    }

    @Override
    public TimeoutImageEditReplacePatchable rolling() {
        return new ReplicationControllerOperationsImpl(((RollingOperationContext)this.context).withRolling(true));
    }

    @Override
    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of ReplicationControllers");
    }

    @Override
    public ImageEditReplacePatchable<ReplicationController, ReplicationController, DoneableReplicationController> withTimeout(long timeout, TimeUnit unit) {
        return new ReplicationControllerOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(unit.toMillis(timeout)).withRollingTimeUnit(TimeUnit.MILLISECONDS));
    }

    @Override
    public ImageEditReplacePatchable<ReplicationController, ReplicationController, DoneableReplicationController> withTimeoutInMillis(long timeoutInMillis) {
        return new ReplicationControllerOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(timeoutInMillis));
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource<Pod, DoneablePod>> podOperationList = this.doGetLog(isPretty);
        for (PodResource<Pod, DoneablePod> podOperation : podOperationList) {
            stringBuilder.append((String)podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource<Pod, DoneablePod>> doGetLog(boolean isPretty) {
        ReplicationController rc = (ReplicationController)this.fromServer().get();
        return PodOperationUtil.getPodOperationsForController(this.context, rc.getMetadata().getUid(), ReplicationControllerOperationsImpl.getReplicationControllerPodLabels(rc), isPretty, this.podLogWaitTimeout);
    }

    @Override
    public Reader getLogReader() {
        List<PodResource<Pod, DoneablePod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Reading logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        List<PodResource<Pod, DoneablePod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Watching logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return (LogWatch)podResources.get(0).watchLog(out);
        }
        return null;
    }

    @Override
    public Loggable<String, LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        return new ReplicationControllerOperationsImpl((RollingOperationContext)this.context, logWaitTimeout);
    }

    @Override
    public ReplicationController pause() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" pausing is not supported");
    }

    @Override
    public ReplicationController resume() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" resuming is not supported");
    }

    @Override
    public ReplicationController restart() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" restarting is not supported");
    }

    @Override
    public ReplicationController undo() {
        throw new UnsupportedOperationException("no rollbacker has been implemented for \"" + ((ReplicationController)this.get()).getKind() + "\"");
    }

    static Map<String, String> getReplicationControllerPodLabels(ReplicationController replicationController) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (replicationController != null && replicationController.getSpec() != null && replicationController.getSpec().getSelector() != null) {
            labels.putAll(replicationController.getSpec().getSelector());
        }
        return labels;
    }
}

