/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.internal.PatchUtils;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.zjsonpatch.JsonDiff;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OperationSupport {
    public static final MediaType JSON = MediaType.parse((String)"application/json");
    public static final MediaType JSON_PATCH = MediaType.parse((String)"application/json-patch+json");
    protected static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    protected static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String CLIENT_STATUS_FLAG = "CLIENT_STATUS_FLAG";
    protected final OkHttpClient client;
    protected final Config config;
    protected final String resourceT;
    protected final String namespace;
    protected final String name;
    protected final String apiGroup;
    protected final String apiVersion;

    public OperationSupport() {
        this(null, null, null, null, null, null, null);
    }

    public OperationSupport(OkHttpClient client, Config config, String apiGroup, String apiVersion, String resourceT, String namespace, String name) {
        this.client = client;
        this.config = config;
        this.resourceT = resourceT;
        this.namespace = namespace;
        this.name = name;
        this.apiGroup = apiGroup;
        this.apiVersion = apiVersion != null ? apiVersion : (config != null ? config.getApiVersion() : "v1");
    }

    public String getAPIGroup() {
        return this.apiGroup;
    }

    public String getAPIVersion() {
        return this.apiVersion;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean isResourceNamespaced() {
        return true;
    }

    public URL getRootUrl() {
        try {
            if (this.apiGroup != null) {
                return new URL(URLUtils.join(this.config.getMasterUrl().toString(), "apis", this.apiGroup, this.apiVersion));
            }
            return new URL(URLUtils.join(this.config.getMasterUrl().toString(), "api", this.apiVersion));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public URL getNamespacedUrl(String namespace) throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.isResourceNamespaced() && Utils.isNotNullOrEmpty(namespace)) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), "namespaces", namespace));
        }
        requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.resourceT));
        return requestUrl;
    }

    public URL getNamespacedUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace());
    }

    public <T> URL getNamespacedUrl(T item) throws MalformedURLException {
        return this.getNamespacedUrl(this.checkNamespace(item));
    }

    public URL getResourceUrl(String namespace, String name) throws MalformedURLException {
        if (name == null) {
            return this.getNamespacedUrl(namespace);
        }
        return new URL(URLUtils.join(this.getNamespacedUrl(namespace).toString(), name));
    }

    public URL getResourceUrl() throws MalformedURLException {
        if (this.name == null) {
            return this.getNamespacedUrl();
        }
        return new URL(URLUtils.join(this.getNamespacedUrl().toString(), this.name));
    }

    protected <T> String checkNamespace(T item) {
        String itemNs;
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata && ((HasMetadata)item).getMetadata() != null ? ((HasMetadata)item).getMetadata().getNamespace() : null;
        if (Utils.isNullOrEmpty(operationNs) && Utils.isNullOrEmpty(itemNs)) {
            if (!this.isResourceNamespaced()) {
                return null;
            }
            throw new KubernetesClientException("Namespace not specified. But operation requires namespace.");
        }
        if (Utils.isNullOrEmpty(itemNs)) {
            return operationNs;
        }
        if (Utils.isNullOrEmpty(operationNs)) {
            return itemNs;
        }
        if (itemNs.equals(operationNs)) {
            return itemNs;
        }
        throw new KubernetesClientException("Namespace mismatch. Item namespace:" + itemNs + ". Operation namespace:" + operationNs + ".");
    }

    protected <T> String checkName(T item) {
        String itemName;
        String operationName = this.getName();
        String string = itemName = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata().getName() : null;
        if (Utils.isNullOrEmpty(operationName) && Utils.isNullOrEmpty(itemName)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemName)) {
            return operationName;
        }
        if (Utils.isNullOrEmpty(operationName)) {
            return itemName;
        }
        if (itemName.equals(operationName)) {
            return itemName;
        }
        throw new KubernetesClientException("Name mismatch. Item name:" + itemName + ". Operation name:" + operationName + ".");
    }

    protected <T> void handleDelete(T resource, long gracePeriodSeconds, boolean cascading) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        this.handleDelete(this.getResourceUrl(this.checkNamespace(resource), this.checkName(resource)), gracePeriodSeconds, cascading);
    }

    protected void handleDelete(URL requestUrl, long gracePeriodSeconds, boolean cascading) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        RequestBody requestBody = null;
        DeleteOptions deleteOptions = new DeleteOptions();
        deleteOptions.setOrphanDependents(Boolean.valueOf(!cascading));
        if (gracePeriodSeconds >= 0L) {
            deleteOptions.setGracePeriodSeconds(Long.valueOf(gracePeriodSeconds));
        }
        requestBody = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString((Object)deleteOptions));
        Request.Builder requestBuilder = new Request.Builder().delete(requestBody).url(requestUrl);
        this.handleResponse(requestBuilder, null);
    }

    protected <T, I> T handleCreate(I resource, Class<T> outputType) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString(resource));
        Request.Builder requestBuilder = new Request.Builder().post(body).url(this.getNamespacedUrl(this.checkNamespace(resource)));
        return this.handleResponse(requestBuilder, outputType);
    }

    protected <T> T handleReplace(T updated, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString(updated));
        Request.Builder requestBuilder = new Request.Builder().put(body).url(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated)));
        return this.handleResponse(requestBuilder, type);
    }

    protected <T> T handlePatch(T current, T updated, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        JsonNode diff = JsonDiff.asJson((JsonNode)PatchUtils.patchMapper().valueToTree(current), (JsonNode)PatchUtils.patchMapper().valueToTree(updated));
        RequestBody body = RequestBody.create((MediaType)JSON_PATCH, (String)JSON_MAPPER.writeValueAsString((Object)diff));
        Request.Builder requestBuilder = new Request.Builder().patch(body).url(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated)));
        return this.handleResponse(requestBuilder, type);
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        Request.Builder requestBuilder = new Request.Builder().get().url(resourceUrl);
        return this.handleResponse(requestBuilder, type);
    }

    protected <T> T handleResponse(Request.Builder requestBuilder, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return this.handleResponse(this.client, requestBuilder, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T handleResponse(OkHttpClient client, Request.Builder requestBuilder, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        Request request = requestBuilder.build();
        Response response = client.newCall(request).execute();
        try (ResponseBody body = response.body();){
            this.assertResponseCode(request, response);
            if (type != null) {
                Object object = JSON_MAPPER.readValue(body.byteStream(), type);
                return (T)object;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            if (!(e instanceof KubernetesClientException)) throw OperationSupport.requestException(request, e);
            throw e;
        }
    }

    protected void assertResponseCode(Request request, Response response) {
        int statusCode = response.code();
        String customMessage = this.config.getErrorMessages().get(statusCode);
        if (response.isSuccessful()) {
            return;
        }
        if (customMessage != null) {
            throw OperationSupport.requestFailure(request, OperationSupport.createStatus(statusCode, customMessage));
        }
        throw OperationSupport.requestFailure(request, OperationSupport.createStatus(response));
    }

    public static Status createStatus(Response response) {
        int statusCode = response.code();
        String statusMessage = "";
        ResponseBody body = response != null ? response.body() : null;
        try {
            if (response == null) {
                statusMessage = "No response";
            } else if (body != null) {
                statusMessage = body.string();
            } else if (response.message() != null) {
                statusMessage = response.message();
            }
            Status status = (Status)JSON_MAPPER.readValue(statusMessage, Status.class);
            if (status.getCode() == null) {
                status = ((StatusBuilder)new StatusBuilder(status).withCode(Integer.valueOf(statusCode))).build();
            }
            return status;
        }
        catch (JsonParseException e) {
            return OperationSupport.createStatus(statusCode, statusMessage);
        }
        catch (IOException e) {
            return OperationSupport.createStatus(statusCode, statusMessage);
        }
    }

    public static Status createStatus(int statusCode, String message) {
        Status status = ((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(statusCode))).withMessage(message)).build();
        status.getAdditionalProperties().put(CLIENT_STATUS_FLAG, "true");
        return status;
    }

    public static KubernetesClientException requestFailure(Request request, Status status) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failure executing: ").append(request.method()).append(" at: ").append(request.url().toString()).append(".");
        if (status.getMessage() != null && !status.getMessage().isEmpty()) {
            sb.append(" Message: ").append(status.getMessage()).append(".");
        }
        if (status != null && !status.getAdditionalProperties().containsKey(CLIENT_STATUS_FLAG)) {
            sb.append(" Received status: ").append(status).append(".");
        }
        return new KubernetesClientException(sb.toString(), status.getCode(), status);
    }

    public static KubernetesClientException requestException(Request request, Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error executing: ").append(request.method()).append(" at: ").append(request.url().toString()).append(". Cause: ").append(e.getMessage());
        return new KubernetesClientException(sb.toString(), e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static <T> T unmarshal(InputStream is) throws KubernetesClientException {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            ObjectMapper mapper = JSON_MAPPER;
            if (intch != 123) {
                mapper = YAML_MAPPER;
            }
            Object object = mapper.readerFor(KubernetesResource.class).readValue((InputStream)bis);
            return (T)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static <T> T unmarshal(InputStream is, Class<T> type) throws KubernetesClientException {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            ObjectMapper mapper = JSON_MAPPER;
            if (intch != 123) {
                mapper = YAML_MAPPER;
            }
            Object object = mapper.readValue((InputStream)bis, type);
            return (T)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public Config getConfig() {
        return this.config;
    }
}

