/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.internal.CertUtils;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SSLUtils.class);

    private SSLUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isHttpsAvailable(Config config) {
        EditableConfig sslConfig = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(config).withMasterUrl(Config.HTTPS_PROTOCOL_PREFIX + config.getMasterUrl())).withRequestTimeout(1000)).withConnectionTimeout(1000)).build();
        OkHttpClient client = HttpClientUtils.createHttpClient(config);
        try {
            boolean bl;
            Throwable throwable;
            ResponseBody body;
            block18: {
                block19: {
                    Request request = new Request.Builder().get().url(sslConfig.getMasterUrl()).build();
                    Response response = client.newCall(request).execute();
                    body = response.body();
                    throwable = null;
                    bl = response.isSuccessful();
                    if (body == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        body.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                body.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (body != null) {
                            if (throwable != null) {
                                try {
                                    body.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                body.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Throwable t) {
                    LOG.warn("SSL handshake failed. Falling back to insecure connection.");
                }
            }
        }
        finally {
            if (client != null && client.getConnectionPool() != null) {
                client.getConnectionPool().evictAll();
            }
        }
        return false;
    }

    public static SSLContext sslContext(Config config) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, IOException, InvalidKeySpecException, KeyManagementException {
        return SSLUtils.sslContext(SSLUtils.keyManagers(config), SSLUtils.trustManagers(config), config.isTrustCerts());
    }

    public static SSLContext sslContext(KeyManager[] keyManagers, TrustManager[] trustManagers, boolean trustCerts) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, IOException, InvalidKeySpecException, KeyManagementException {
        if (trustManagers == null && trustCerts) {
            trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }

    public static TrustManager[] trustManagers(Config config) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return SSLUtils.trustManagers(config.getCaCertData(), config.getCaCertFile(), config.isTrustCerts());
    }

    public static TrustManager[] trustManagers(String certData, String certFile, boolean isTrustCerts) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        TrustManager[] trustManagers = null;
        if (!isTrustCerts && (Utils.isNotNullOrEmpty(certData) || Utils.isNotNullOrEmpty(certFile))) {
            KeyStore trustStore = CertUtils.createTrustStore(certData, certFile);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            trustManagers = tmf.getTrustManagers();
        }
        return trustManagers;
    }

    public static KeyManager[] keyManagers(Config config) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, CertificateException, InvalidKeySpecException, IOException {
        return SSLUtils.keyManagers(config.getClientCertData(), config.getClientCertFile(), config.getClientKeyData(), config.getClientKeyFile(), config.getClientKeyAlgo(), config.getClientKeyPassphrase());
    }

    public static KeyManager[] keyManagers(String certData, String certFile, String keyData, String keyFile, String algo, String passphrase) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, CertificateException, InvalidKeySpecException, IOException {
        KeyManager[] keyManagers = null;
        if ((Utils.isNotNullOrEmpty(certData) || Utils.isNotNullOrEmpty(certFile)) && (Utils.isNotNullOrEmpty(keyData) || Utils.isNotNullOrEmpty(keyFile))) {
            KeyStore keyStore = CertUtils.createKeyStore(certData, certFile, keyData, keyFile, algo, passphrase.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, passphrase.toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        return keyManagers;
    }

    public static KeyManager[] keyManagers(InputStream certInputStream, InputStream keyInputStream, String algo, String passphrase) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, CertificateException, InvalidKeySpecException, IOException {
        KeyStore keyStore = CertUtils.createKeyStore(certInputStream, keyInputStream, algo, passphrase.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, passphrase.toCharArray());
        return kmf.getKeyManagers();
    }
}

