/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.codec.string;

import io.fabric8.kubernetes.client.internal.org.jboss.netty.buffer.ChannelBuffers;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.Channel;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelHandler;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelHandlerContext;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public class StringEncoder
extends OneToOneEncoder {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof String) {
            return ChannelBuffers.copiedBuffer(ctx.getChannel().getConfig().getBufferFactory().getDefaultOrder(), (String)msg, this.charset);
        }
        return msg;
    }
}

