/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.handlers;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.KubernetesListOperationsImpl;
import java.util.ArrayList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class KubernetesListHandler
implements ResourceHandler<KubernetesList, KubernetesListBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesListHandler.class);

    @Override
    public String getKind() {
        return io.fabric8.kubernetes.api.model.Service.class.getSimpleName();
    }

    @Override
    public KubernetesList create(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        return new KubernetesListOperationsImpl(client, config, namespace, null, true, item, null).create(new KubernetesList[0]);
    }

    @Override
    public KubernetesList replace(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        ArrayList<HasMetadata> replacedItems = new ArrayList<HasMetadata>();
        for (HasMetadata metadata : item.getItems()) {
            ResourceHandler handler = Handlers.get(item.getKind());
            if (handler == null) {
                LOGGER.warn("No handler found for:" + item.getKind() + ". Ignoring");
                continue;
            }
            replacedItems.add(handler.replace(client, config, namespace, metadata));
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder(item).withItems(replacedItems)).build();
    }

    @Override
    public KubernetesList reload(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        ArrayList<HasMetadata> replacedItems = new ArrayList<HasMetadata>();
        for (HasMetadata metadata : item.getItems()) {
            ResourceHandler handler = Handlers.get(item.getKind());
            if (handler == null) {
                LOGGER.warn("No handler found for:" + item.getKind() + ". Ignoring");
                continue;
            }
            replacedItems.add(handler.reload(client, config, namespace, metadata));
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder(item).withItems(replacedItems)).build();
    }

    @Override
    public KubernetesListBuilder edit(KubernetesList item) {
        return new KubernetesListBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        return new KubernetesListOperationsImpl(client, config, namespace, null, true, item, null).delete(item);
    }
}

