/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DoneableKubernetesList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListOperation;
import io.fabric8.kubernetes.client.dsl.CreateFromServerGettable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Loadable;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KubernetesListOperationsImpl
extends OperationSupport
implements ClientKubernetesListOperation,
ClientKubernetesListMixedOperation,
Loadable<InputStream, CreateFromServerGettable<KubernetesList, KubernetesList, DoneableKubernetesList>>,
CreateFromServerGettable<KubernetesList, KubernetesList, DoneableKubernetesList> {
    private KubernetesList item;

    public KubernetesListOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, namespace, (String)null, (Boolean)null, (KubernetesList)null, (String)null);
    }

    public KubernetesListOperationsImpl(OkHttpClient client, Config config, String namespace, String name, Boolean cascading, KubernetesList item, String resourceVersion) {
        super(client, config, null, null, null, namespace, null);
    }

    @Override
    public ClientKubernetesListNonNamespaceOperation inNamespace(String namespace) {
        return new KubernetesListOperationsImpl(this.client, this.config, namespace);
    }

    public KubernetesList create(KubernetesList ... items) {
        ArrayList<HasMetadata> createdItems = new ArrayList<HasMetadata>();
        if (items.length == 0) {
            items = new KubernetesList[]{this.get()};
        }
        for (KubernetesList i : items) {
            for (HasMetadata r : i.getItems()) {
                HasMetadata created = this.create(r);
                createdItems.add(created);
            }
        }
        KubernetesList createdList = new KubernetesList();
        createdList.setItems(createdItems);
        return createdList;
    }

    @Override
    public DoneableKubernetesList createNew() {
        return new DoneableKubernetesList((Visitor)new Visitor<KubernetesList>(){

            public void visit(KubernetesList list) {
                try {
                    KubernetesListOperationsImpl.this.create(list);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        });
    }

    @Override
    public CreateFromServerGettable<KubernetesList, KubernetesList, DoneableKubernetesList> load(InputStream is) {
        this.item = KubernetesListOperationsImpl.unmarshal(is, KubernetesList.class);
        return this;
    }

    @Override
    public KubernetesList get() {
        return this.item;
    }

    private <T extends HasMetadata, V extends VisitableBuilder<T, V>> T create(T resource) {
        ResourceHandler handler = Handlers.get(resource.getKind());
        if (handler != null) {
            return (T)((HasMetadata)handler.create(this.client, this.config, this.namespace, resource));
        }
        throw new IllegalStateException("Could not find handler");
    }

    public Boolean delete(KubernetesList ... lists) {
        return this.delete((List)Arrays.asList(lists));
    }

    @Override
    public Boolean delete(List<KubernetesList> lists) {
        for (KubernetesList list : lists) {
            for (HasMetadata item : list.getItems()) {
                ResourceHandler handler = Handlers.get(item.getKind());
                if (handler.delete(this.client, this.config, this.namespace, item).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Gettable<KubernetesList> fromServer() {
        return null;
    }
}

