/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Challenge;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    public static OkHttpClient createHttpClient(final Config config) {
        try {
            OkHttpClient httpClient = new OkHttpClient();
            httpClient.setFollowRedirects(true);
            httpClient.setFollowSslRedirects(true);
            if (config.isTrustCerts()) {
                httpClient.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                });
            }
            TrustManager[] trustManagers = SSLUtils.trustManagers(config);
            KeyManager[] keyManagers = SSLUtils.keyManagers(config);
            if (keyManagers != null || trustManagers != null || config.isTrustCerts()) {
                try {
                    SSLContext sslContext = SSLUtils.sslContext(keyManagers, trustManagers, config.isTrustCerts());
                    httpClient.setSslSocketFactory(sslContext.getSocketFactory());
                }
                catch (GeneralSecurityException e) {
                    throw new AssertionError();
                }
            }
            if (Utils.isNotNullOrEmpty(config.getUsername()) && Utils.isNotNullOrEmpty(config.getPassword())) {
                httpClient.setAuthenticator(new Authenticator(){

                    public Request authenticate(Proxy proxy, Response response) throws IOException {
                        List challenges = response.challenges();
                        Request request = response.request();
                        HttpUrl url = request.httpUrl();
                        int size = challenges.size();
                        for (int i = 0; i < size; ++i) {
                            Challenge challenge = (Challenge)challenges.get(i);
                            if (!"Basic".equalsIgnoreCase(challenge.getScheme())) continue;
                            String credential = Credentials.basic((String)config.getUsername(), (String)config.getPassword());
                            return request.newBuilder().header("Authorization", credential).build();
                        }
                        return null;
                    }

                    public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
                        return null;
                    }
                });
            } else if (config.getOauthToken() != null) {
                httpClient.interceptors().add(new Interceptor(){

                    public Response intercept(Interceptor.Chain chain) throws IOException {
                        Request authReq = chain.request().newBuilder().addHeader("Authorization", "Bearer " + config.getOauthToken()).build();
                        return chain.proceed(authReq);
                    }
                });
            }
            Logger reqLogger = LoggerFactory.getLogger(LoggingInterceptor.class);
            if (reqLogger.isTraceEnabled()) {
                httpClient.networkInterceptors().add(new LoggingInterceptor(reqLogger));
            }
            if (config.getConnectionTimeout() > 0) {
                httpClient.setConnectTimeout((long)config.getConnectionTimeout(), TimeUnit.MILLISECONDS);
            }
            if (config.getRequestTimeout() > 0) {
                httpClient.setReadTimeout((long)config.getRequestTimeout(), TimeUnit.MILLISECONDS);
            }
            if (config.getMasterUrl().toLowerCase().startsWith(Config.HTTP_PROTOCOL_PREFIX) || config.getMasterUrl().startsWith(Config.HTTPS_PROTOCOL_PREFIX)) {
                try {
                    URL proxyUrl = HttpClientUtils.getProxyUrl(config);
                    if (proxyUrl != null) {
                        httpClient.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort())));
                    }
                }
                catch (MalformedURLException e) {
                    throw new KubernetesClientException("Invalid proxy server configuration", e);
                }
            }
            return httpClient;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private static URL getProxyUrl(Config config) throws MalformedURLException {
        URL master = new URL(config.getMasterUrl());
        String host = master.getHost();
        for (String noProxy : config.getNoProxy()) {
            if (!host.endsWith(noProxy)) continue;
            return null;
        }
        String proxy = config.getHttpsProxy();
        if (master.getProtocol().equals("http")) {
            proxy = config.getHttpProxy();
        }
        if (proxy != null) {
            return new URL(proxy);
        }
        return null;
    }

    private static class LoggingInterceptor
    implements Interceptor {
        private final Logger logger;

        LoggingInterceptor(Logger logger) {
            this.logger = logger;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            long t1 = System.nanoTime();
            this.logger.trace(String.format("Sending request %s %s on %s%n%s", request.method(), request.url(), chain.connection(), request.headers()));
            Response response = chain.proceed(request);
            long t2 = System.nanoTime();
            this.logger.trace(String.format("Received %d response for %s %s in %.1fms%n%s", response.code(), response.request().method(), response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
            return response;
        }
    }
}

