/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.Binding;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apps.ControllerRevision;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.authorization.v1.LocalSubjectAccessReview;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectAccessReview;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReview;
import io.fabric8.kubernetes.api.model.authorization.v1.SubjectAccessReview;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJob;
import io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.policy.v1beta1.PodDisruptionBudget;
import io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicy;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.scheduling.v1beta1.PriorityClass;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachment;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriver;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINode;
import io.fabric8.kubernetes.client.lib.FileSystem;
import io.fabric8.kubernetes.client.utils.CommonThreadPool;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class UtilsTest {
    UtilsTest() {
    }

    @Test
    void existingSysPropShouldReturnValue() {
        System.setProperty("something", "value");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"something"));
        System.getProperties().remove("something");
    }

    @Test
    void missingSysPropAndEnvVarShouldReturnNull() {
        org.junit.jupiter.api.Assertions.assertNull((Object)Utils.getSystemPropertyOrEnvVar((String)"doesn't exist"));
    }

    @Test
    void existingEnvVarShouldReturnValue() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"ENV_VAR_EXISTS"));
    }

    @Test
    void existingEnvVarShouldReturnValueFromConvertedSysPropName() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"env.var.exists"));
    }

    @Test
    void existingEnvVarShouldReturnBooleanValueFromConvertedSysPropName() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.getSystemPropertyOrEnvVar((String)"env.var.exists.boolean", (Boolean)false));
    }

    @Test
    void missingEnvVarShouldReturnDefaultValue() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.getSystemPropertyOrEnvVar((String)"DONT_EXIST", (Boolean)true));
    }

    @Test
    @DisplayName(value="interpolateString, String with no placeholders and empty parameters, should return input")
    void interpolateStringTest() {
        String input = "I don't have placeholders";
        String result = Utils.interpolateString((String)"I don't have placeholders", Collections.emptyMap());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"I don't have placeholders", (Object)result);
    }

    @Test
    @DisplayName(value="interpolateString, String with no placeholders and null parameters, should return input")
    void interpolateStringNullParametersTest() {
        String input = "I don't have placeholders";
        String result = Utils.interpolateString((String)"I don't have placeholders", null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"I don't have placeholders", (Object)result);
    }

    @Test
    @DisplayName(value="interpolateString, String with no placeholders and null parameter values, should return input")
    void interpolateStringNullParameterValuesTest() {
        String input = "I don't have placeholders";
        String result = Utils.interpolateString((String)"I don't have placeholders", Collections.singletonMap("KEY", null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"I don't have placeholders", (Object)result);
    }

    @Test
    @DisplayName(value="interpolateString, String with mixed placeholders and parameters, should return interpolated input")
    void interpolateStringWithParametersTest() {
        String input = "This is a \"${SINGLE_CURLY_BRACE}\" and the following is code ${NOT_REPLACED}: \"${{RENDER_UNQUOTED}}\" ${{ALREADY_UNQUOTED}}";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("SINGLE_CURLY_BRACE", "template string");
        parameters.put("RENDER_UNQUOTED", "'1' === '1';");
        parameters.put("ALREADY_UNQUOTED", "/* END */");
        parameters.put("NOT_THERE", "/* END */");
        parameters.put(null, "NULL key is ignored");
        parameters.put("NULL_VALUE", null);
        String result = Utils.interpolateString((String)"This is a \"${SINGLE_CURLY_BRACE}\" and the following is code ${NOT_REPLACED}: \"${{RENDER_UNQUOTED}}\" ${{ALREADY_UNQUOTED}}", parameters);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"This is a \"template string\" and the following is code ${NOT_REPLACED}: '1' === '1'; /* END */", (Object)result);
    }

    @Test
    @DisplayName(value="Should test whether resource is namespaced or not")
    void testWhetherNamespacedOrNot() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Binding.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(ComponentStatus.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ConfigMap.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Endpoints.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Event.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(LimitRange.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(Namespace.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(Node.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(PersistentVolumeClaim.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(PersistentVolume.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Pod.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(PodTemplate.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ReplicationController.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ResourceQuota.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Secret.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ServiceAccount.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Service.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(MutatingWebhookConfiguration.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(ValidatingWebhookConfiguration.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(CustomResourceDefinition.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ControllerRevision.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(DaemonSet.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Deployment.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(ReplicaSet.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(StatefulSet.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(TokenReview.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(LocalSubjectAccessReview.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(SelfSubjectAccessReview.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(SelfSubjectRulesReview.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(SubjectAccessReview.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(HorizontalPodAutoscaler.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(CronJob.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Job.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(CertificateSigningRequest.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Lease.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(EndpointSlice.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Ingress.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(NetworkPolicy.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(PodDisruptionBudget.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(PodSecurityPolicy.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(ClusterRoleBinding.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(ClusterRole.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(RoleBinding.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Utils.isResourceNamespaced(Role.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(PriorityClass.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(CSIDriver.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(CSINode.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(StorageClass.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Utils.isResourceNamespaced(VolumeAttachment.class));
    }

    @Test
    @DisplayName(value="isNotNullOrEmpty, null, should return false")
    void isNotNullOrEmpty() {
        boolean result1 = Utils.isNotNullOrEmpty((Map)null);
        boolean result2 = Utils.isNotNullOrEmpty((String)null);
        boolean result3 = Utils.isNotNullOrEmpty((String)"");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result3);
    }

    @Test
    @DisplayName(value="isNotNull, null, should return false")
    void isNotNull() {
        Object[] emptyArray = new String[]{};
        boolean result = Utils.isNotNull((Object[])emptyArray);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="isNotNullOrEmpty, some null values, should return true")
    void isNotNullOrEmptySomeAreNullTest() {
        String[] testSample = new String[]{"notNullObj", null, null};
        boolean result = Utils.isNotNullOrEmpty((String[])testSample);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="isNotNull, some null values, should return true")
    void isNotNullSomeAreNullTest() {
        Object[] testSample = new String[]{"notNullObj", null, null};
        boolean result = Utils.isNotNull((Object[])testSample);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
    }

    @Test
    @DisplayName(value="isNotNull, no null values, should return true")
    void isNotNullNoneAreNullTest() {
        Object[] testSample = new String[]{"Not null", "Not null either"};
        boolean result = Utils.isNotNull((Object[])testSample);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="test getting system path")
    void testGetSystemPathVariable() {
        String pathVariable = Utils.getSystemPathVariable();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)pathVariable);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pathVariable.contains(File.pathSeparator));
    }

    @Test
    @DisplayName(value="Should get command prefix")
    void testGetCommandPlatformPrefix() {
        List commandPrefix = Utils.getCommandPlatformPrefix();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)commandPrefix);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)commandPrefix.size());
        switch (FileSystem.getCurrent()) {
            case WINDOWS: {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"cmd.exe", commandPrefix.get(0));
                org.junit.jupiter.api.Assertions.assertEquals((Object)"/c", commandPrefix.get(1));
                break;
            }
            default: {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"sh", commandPrefix.get(0));
                org.junit.jupiter.api.Assertions.assertEquals((Object)"-c", commandPrefix.get(1));
            }
        }
    }

    @Test
    void testDaemonThreadFactory() {
        ThreadFactory tf = Utils.daemonThreadFactory((Object)this);
        Thread t = tf.newThread(() -> {});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)t.isDaemon());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)t.getName().startsWith(UtilsTest.class.getSimpleName()));
    }

    @Test
    void testSerialExecution() throws Exception {
        AtomicInteger counter = new AtomicInteger();
        CompletableFuture completableFuture = new CompletableFuture();
        Utils.scheduleWithVariableRate(completableFuture, (Executor)CommonThreadPool.get(), () -> {
            counter.getAndIncrement();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)counter.get());
            completableFuture.complete(null);
        }, (long)0L, () -> 1L, (TimeUnit)TimeUnit.MILLISECONDS);
        completableFuture.get(1L, TimeUnit.SECONDS);
    }

    @Test
    void generateId() {
        ((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)Utils.generateId()).isNotNull()).satisfies(new ThrowingConsumer[]{uuid -> Assertions.assertThat((long)uuid.getLeastSignificantBits()).isPositive()})).satisfies(new ThrowingConsumer[]{uuid -> Assertions.assertThat((long)uuid.getMostSignificantBits()).isZero()});
    }
}

