/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.http.RecordedRequest;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class AbstractHttpGetTest {
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    protected abstract Class<? extends Exception> getConnectionFailedExceptionType();

    @Test
    @DisplayName(value="Should send a GET request with body")
    public void get() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/get")).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"GET", RecordedRequest::getMethod)).returns((Object)"/get", RecordedRequest::getPath)).returns((Object)"HTTP/1.1", RecordedRequest::getHttpVersion);
    }

    @Test
    @DisplayName(value="Unsupported response type throws exception")
    public void unsupportedResponseType() {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            HttpRequest httpRequest = client.newHttpRequestBuilder().uri(server.url("/get")).build();
            Assertions.assertThatIllegalArgumentException().isThrownBy(() -> client.sendAsync(httpRequest, Boolean.class)).withMessageStartingWith("Unsupported response type: ").withMessageContaining("Boolean");
        }
    }

    @Test
    @DisplayName(value="Test that headers are case insensitive")
    public void caseInsensitiveHeaders() throws Exception {
        String value = "values";
        ((TimesOnceableOrHttpHeaderable)((TimesOnceableOrHttpHeaderable)((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/header")).andReturn(200, (Object)"values")).withHeader("fakeheader", "firstvalue")).withHeader("FAKEHEADER", "secondvalue")).always();
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            HttpRequest request = client.newHttpRequestBuilder().uri(server.url("/header")).build();
            HttpResponse result = (HttpResponse)client.sendAsync(request, String.class).get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)result).satisfies(new ThrowingConsumer[]{r -> ((ListAssert)Assertions.assertThat((List)r.headers("FakeHeader")).isNotEmpty()).containsExactly((Object[])new String[]{"firstvalue", "secondvalue"})});
        }
    }

    @DisplayName(value="Supported response body types")
    @ParameterizedTest(name="{index}: {0}")
    @ValueSource(classes={String.class, byte[].class, Reader.class, InputStream.class})
    void supportedResponseBodyTypes(Class<?> type) throws Exception {
        int length = 16384;
        String value = new String(new byte[16384]);
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/type")).andReturn(200, (Object)value)).always();
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            HttpRequest request = client.newHttpRequestBuilder().uri(server.url("/type")).build();
            HttpResponse result = (HttpResponse)client.sendAsync(request, type).get(10L, TimeUnit.SECONDS);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).returns((Object)String.valueOf(16384), r -> r.header("Content-Length"))).satisfies(new ThrowingConsumer[]{r -> Assertions.assertThat((Object)r.body()).isInstanceOf(type)})).satisfies(new ThrowingConsumer[]{r -> Assertions.assertThat((String)r.bodyString()).isEqualTo(value)});
        }
    }
}

