/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public abstract class AbstractConfiguredClientTest {
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    private HttpClient clientWithDefaultConfiguration() {
        return this.getHttpClientFactory().newBuilder(Config.empty()).build();
    }

    @Test
    public void userAgentTest() throws Exception {
        try (HttpClient client = this.clientWithDefaultConfiguration();){
            ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/consume-bytes")).andReturn(200, (Object)"This is the response body as bytes")).always();
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/consume-bytes")).build(), String.class).get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)server.getLastRequest().getHeader("User-Agent")).startsWith((CharSequence)"fabric8-kubernetes-client");
        }
    }

    @Test
    public void multipleClosure() {
        HttpClient client = this.clientWithDefaultConfiguration();
        client.close();
        Assertions.assertThat((boolean)client.isClosed()).isTrue();
        IntStream.range(0, 10).forEach(i -> client.close());
        Assertions.assertThatNoException().isThrownBy(() -> ((HttpClient)client).close());
    }
}

