/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Custom;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.Good;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class CustomResourceTest {
    CustomResourceTest() {
    }

    @Test
    void missingGroupAndVersionShouldFail() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MissingApiVersion());
    }

    @Test
    void valuesShouldProperlyBeComputedFromDefaultsAndAnnotations() {
        Good good = new Good();
        Assertions.assertEquals((Object)"Good", (Object)good.getKind());
        Assertions.assertEquals((Object)"goods", (Object)good.getPlural());
        Assertions.assertEquals((Object)"good", (Object)good.getSingular());
        Assertions.assertEquals((Object)"sample.fabric8.io/v1beta1", (Object)good.getApiVersion());
        Assertions.assertEquals((Object)(good.getPlural() + ".sample.fabric8.io"), (Object)good.getCRDName());
        Assertions.assertEquals((Object)"v1beta1", (Object)good.getVersion());
        Assertions.assertEquals((Object)"sample.fabric8.io", (Object)good.getGroup());
        Assertions.assertTrue((boolean)good.isServed());
        Assertions.assertTrue((boolean)good.isStorage());
    }

    @Test
    @DisplayName(value="fully annotated custom resource should use annotation values instead of defaults")
    void customCRShouldWork() {
        Custom custom = new Custom();
        Assertions.assertEquals((Object)"CustomCR", (Object)custom.getKind());
        Assertions.assertEquals((Object)"foo", (Object)custom.getSingular());
        Assertions.assertEquals((Object)"fooes", (Object)custom.getPlural());
        Assertions.assertEquals((Object)"sample.fabric8.io/v1beta1", (Object)custom.getApiVersion());
        Assertions.assertEquals((Object)(custom.getPlural() + ".sample.fabric8.io"), (Object)custom.getCRDName());
        Assertions.assertEquals((Object)"v1beta1", (Object)custom.getVersion());
        Assertions.assertEquals((Object)"sample.fabric8.io", (Object)custom.getGroup());
        Assertions.assertEquals((int)1, (int)Custom.getCategories(Custom.class).length);
        Assertions.assertEquals((Object)"Cat1", (Object)Custom.getCategories(Custom.class)[0]);
        Assertions.assertFalse((boolean)custom.isServed());
        Assertions.assertFalse((boolean)custom.isStorage());
    }

    @Test
    void untypedCustomResourceInitShouldWork() {
        Untyped cr = new Untyped();
        Assertions.assertNull((Object)cr.getSpec());
        Assertions.assertNull((Object)cr.getStatus());
    }

    @Test
    void voidVoidCustomResourceInitShouldWork() {
        VoidVoid cr = new VoidVoid();
        Assertions.assertNull((Object)cr.getSpec());
        Assertions.assertNull((Object)cr.getStatus());
    }

    @Test
    void subclassWithOverriddenInitShouldWork() {
        CRI cri = new CRI();
        Assertions.assertNull((Object)cri.getSpec());
        Assertions.assertEquals((int)7, (Integer)((Integer)cri.getStatus()));
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class VoidVoid
    extends CustomResource<Void, Void> {
        private VoidVoid() {
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class CRI
    extends CustomResource<String, Integer> {
        private CRI() {
        }

        protected Integer initStatus() {
            return 7;
        }
    }

    @Group(value="example.com")
    @Version(value="v1")
    private static class Untyped
    extends CustomResource {
        private Untyped() {
        }
    }

    private static class MissingApiVersion
    extends CustomResource {
        private MissingApiVersion() {
        }
    }
}

