/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection.resourcelock;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public abstract class ResourceLock<T extends HasMetadata>
implements Lock {
    private final ObjectMeta meta;
    private final String identity;

    public ResourceLock(String namespace, String name, String identity) {
        this(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withNamespace(namespace)).withName(name)).build(), identity);
    }

    public ResourceLock(ObjectMeta meta, String identity) {
        this.meta = meta;
        Objects.requireNonNull(meta.getNamespace(), "namespace is required");
        Objects.requireNonNull(meta.getName(), "name is required");
        this.identity = Objects.requireNonNull(identity, "identity is required");
    }

    protected abstract Class<T> getKind();

    @Override
    public LeaderElectionRecord get(KubernetesClient client) {
        return this.getResource(client).map(this::toRecordInternal).orElse(null);
    }

    private Optional<T> getResource(KubernetesClient client) {
        return Optional.ofNullable(((Resource)((NonNamespaceOperation)client.resources(this.getKind()).inNamespace(this.meta.getNamespace())).withName(this.meta.getName())).get());
    }

    @Override
    public void create(KubernetesClient client, LeaderElectionRecord leaderElectionRecord) {
        client.resource(this.toResource(leaderElectionRecord, this.getObjectMeta(leaderElectionRecord.getVersion()))).create();
    }

    @Override
    public void update(KubernetesClient client, LeaderElectionRecord leaderElectionRecord) {
        client.resource(this.toResource(leaderElectionRecord, this.getObjectMeta(leaderElectionRecord.getVersion()))).patch(PatchContext.of(PatchType.STRATEGIC_MERGE));
    }

    protected abstract T toResource(LeaderElectionRecord var1, ObjectMeta var2);

    protected LeaderElectionRecord toRecordInternal(T resource) {
        LeaderElectionRecord result = this.toRecord(resource);
        result.setVersion((Serializable)((Object)resource.getMetadata().getResourceVersion()));
        return result;
    }

    protected abstract LeaderElectionRecord toRecord(T var1);

    protected ObjectMeta getObjectMeta(Serializable version) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder(this.meta).withResourceVersion((String)((Object)version))).build();
    }

    @Override
    public String identity() {
        return this.identity;
    }

    @Override
    public String describe() {
        return String.format("%sLock: %s - %s (%s)", this.getKind().getSimpleName(), this.meta.getNamespace(), this.meta.getName(), this.identity);
    }
}

