/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.utils.AsyncUtils;
import io.fabric8.kubernetes.client.utils.ExponentialBackoffIntervalCalculator;
import io.fabric8.kubernetes.client.utils.Utils;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.CompletableFutureAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class AsyncUtilsTest {
    AsyncUtilsTest() {
    }

    @Test
    @DisplayName(value="withTimeout, future is cancelled when timeout is exceeded")
    void withTimeout_timeout() {
        CompletableFuture future = new CompletableFuture();
        AsyncUtils.withTimeout(future, (Duration)Duration.ofMillis(1L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Void cfr_ignored_0 = (Void)future.get(100L, TimeUnit.MILLISECONDS);
        }).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(TimeoutException.class);
    }

    @Test
    @DisplayName(value="withTimeout, future is completed before timeout is exceeded")
    void withTimeout_completes() throws Exception {
        CompletableFuture future = new CompletableFuture();
        AsyncUtils.withTimeout(future, (Duration)Duration.ofMillis(100L));
        Utils.schedule(Runnable::run, () -> future.complete(null), (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assertions.assertThat(future.get(100L, TimeUnit.MILLISECONDS)).isNull();
    }

    @Test
    @DisplayName(value="withTimeout, timeout=0, future remains intact")
    void withTimeout_notApplicable() {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        AsyncUtils.withTimeout(future, (Duration)Duration.ofMillis(0L));
        Assertions.assertThat(future.getNow(null)).isNull();
    }

    @Test
    @DisplayName(value="withTimeout, timeout>0, future has alternative Timeout result")
    void withTimeout_applicableTimeout() {
        CompletableFuture future = new CompletableFuture();
        AsyncUtils.withTimeout(future, (Duration)Duration.ofMillis(1L));
        Awaitility.await().atMost(Duration.ofMillis(101L)).until(future::isDone);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Void cfr_ignored_0 = future.getNow(null);
        }).isInstanceOf(CompletionException.class)).hasCauseInstanceOf(TimeoutException.class);
    }

    @Test
    @DisplayName(value="retryWithExponentialBackoff, action is timed out")
    void retryWithExponentialBackoff_timeout() {
        Supplier<CompletableFuture> action = CompletableFuture::new;
        CompletableFuture onCancel = new CompletableFuture();
        ExponentialBackoffIntervalCalculator retryIntervalCalculator = new ExponentialBackoffIntervalCalculator(1, 1);
        AsyncUtils.ShouldRetry shouldRetry = (v, t, retryInterval) -> retryInterval;
        CompletableFuture result = AsyncUtils.retryWithExponentialBackoff(action, onCancel::complete, (Duration)Duration.ofMillis(1L), (ExponentialBackoffIntervalCalculator)retryIntervalCalculator, (AsyncUtils.ShouldRetry)shouldRetry);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Void cfr_ignored_0 = (Void)result.get(100000L, TimeUnit.MILLISECONDS);
        }).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(TimeoutException.class);
        Assertions.assertThat(onCancel).isNotDone();
    }

    @Test
    @DisplayName(value="retryWithExponentialBackoff, with no retry, should invoke onCancel on action completion with cancelled future")
    void retryWithExponentialBackoff_withCancelledFuture_onCancel() {
        CompletableFuture<Object> action = new CompletableFuture<Object>();
        Supplier<CompletableFuture> actionSupplier = () -> action;
        CompletableFuture onCancel = new CompletableFuture();
        ExponentialBackoffIntervalCalculator retryIntervalCalculator = new ExponentialBackoffIntervalCalculator(1, 0);
        AsyncUtils.ShouldRetry shouldRetry = (v, t, retryInterval) -> -1L;
        CompletableFuture result = AsyncUtils.retryWithExponentialBackoff(actionSupplier, onCancel::complete, (Duration)Duration.ofMillis(100L), (ExponentialBackoffIntervalCalculator)retryIntervalCalculator, (AsyncUtils.ShouldRetry)shouldRetry);
        result.cancel(false);
        action.complete(null);
        ((CompletableFutureAssert)((CompletableFutureAssert)Assertions.assertThat(onCancel).isDone()).isCompleted()).isNotCancelled();
    }

    @Test
    @DisplayName(value="retryWithExponentialBackoff, with retry, should invoke onCancel on action completion before retrying")
    void retryWithExponentialBackoff_withCompletedResult_onCancel() throws Exception {
        CompletableFuture<Boolean> action = new CompletableFuture<Boolean>();
        Supplier<CompletableFuture> actionSupplier = () -> action;
        CompletableFuture onCancel = new CompletableFuture();
        ExponentialBackoffIntervalCalculator retryIntervalCalculator = new ExponentialBackoffIntervalCalculator(1, 1);
        AsyncUtils.ShouldRetry shouldRetry = (v, t, retryInterval) -> retryInterval;
        CompletableFuture result = AsyncUtils.retryWithExponentialBackoff(actionSupplier, onCancel::complete, (Duration)Duration.ofMillis(100L), (ExponentialBackoffIntervalCalculator)retryIntervalCalculator, (AsyncUtils.ShouldRetry)shouldRetry);
        action.complete(true);
        result.get(150L, TimeUnit.MILLISECONDS);
        ((CompletableFutureAssert)((CompletableFutureAssert)Assertions.assertThat(onCancel).isDone()).isCompleted()).isNotCancelled();
    }

    @Test
    @DisplayName(value="retryWithExponentialBackoff, with no retry, should complete future on action completion")
    void retryWithExponentialBackoff_complete() {
        CompletableFuture<Object> action = new CompletableFuture<Object>();
        Supplier<CompletableFuture> actionSupplier = () -> action;
        CompletableFuture onCancel = new CompletableFuture();
        ExponentialBackoffIntervalCalculator retryIntervalCalculator = new ExponentialBackoffIntervalCalculator(1, 0);
        AsyncUtils.ShouldRetry shouldRetry = (v, t, retryInterval) -> -1L;
        CompletableFuture result = AsyncUtils.retryWithExponentialBackoff(actionSupplier, onCancel::complete, (Duration)Duration.ofMillis(100L), (ExponentialBackoffIntervalCalculator)retryIntervalCalculator, (AsyncUtils.ShouldRetry)shouldRetry);
        action.complete(null);
        Assertions.assertThat(onCancel).isNotDone();
        ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)result).isDone()).isCompletedWithValue(null);
    }
}

