/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.WebSocket;
import java.net.URI;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class WebSocketTest {
    WebSocketTest() {
    }

    @ParameterizedTest(name="{index}: toWebSocketUri: from ''{0}'' changes protocol to ''{1}''")
    @MethodSource(value={"toWebSocketUriInput"})
    void toWebSocketUriFromHttp(String uri, String expectedScheme) {
        URI result = WebSocket.toWebSocketUri((URI)URI.create(uri));
        Assertions.assertThat((URI)result).hasScheme(expectedScheme);
    }

    static Stream<Arguments> toWebSocketUriInput() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"http://example.com", "ws"}), Arguments.arguments((Object[])new Object[]{"https://example.com", "wss"}), Arguments.arguments((Object[])new Object[]{"wss://example.com", "wss"}), Arguments.arguments((Object[])new Object[]{"ws://example.com", "ws"}));
    }
}

