/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.client.Custom;
import io.fabric8.kubernetes.client.Good;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class CustomResourceDefinitionContextTest {
    CustomResourceDefinitionContextTest() {
    }

    @Test
    @DisplayName(value="v1beta1CRDFromCustomResourceType correctly generates CRD builder for v1beta1 version")
    void v1beta1CRDFromCustomResourceType() {
        CustomResourceDefinition crd = CustomResourceDefinitionContext.v1beta1CRDFromCustomResourceType(Good.class).build();
        CustomResourceDefinitionSpec spec = crd.getSpec();
        CustomResourceDefinitionNames names = spec.getNames();
        String plural = "goods";
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goods", (Object)names.getPlural());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"good", (Object)names.getSingular());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Good", (Object)names.getKind());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"goods.sample.fabric8.io", (Object)crd.getMetadata().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"v1beta1", (Object)spec.getVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"v1beta1", (Object)((CustomResourceDefinitionVersion)spec.getVersions().get(0)).getName());
    }

    @Test
    @DisplayName(value="v1CRDFromCustomResourceType correctly generates CRD builder for v1 version")
    void v1CRDFromCustomResourceType() {
        io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition crd = CustomResourceDefinitionContext.v1CRDFromCustomResourceType(Custom.class).build();
        io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec spec = crd.getSpec();
        io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNames names = spec.getNames();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"fooes", (Object)names.getPlural());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"foo", (Object)names.getSingular());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"CustomCR", (Object)names.getKind());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"fooes.sample.fabric8.io", (Object)crd.getMetadata().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"v1beta1", (Object)((io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion)spec.getVersions().get(0)).getName());
    }

    @Test
    @DisplayName(value="fromCrd, with v1 CRD, should infer correct properties")
    void fromCrdV1() {
        io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition crd = ((io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.VersionsNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.VersionsNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.VersionsNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder().withNewMetadata().withName("foobar.the-foo.com")).endMetadata()).withNewSpec().withGroup("the-foo.com")).withScope("Namespaced")).withNewNames().withSingular("foobar")).withPlural("foobars")).withKind("Foobar")).endNames()).addNewVersion().withName("v1beta1")).endVersion()).addNewVersion().withName("v1alpha1")).endVersion()).addNewVersion().withName("v1")).endVersion()).endSpec()).build();
        CustomResourceDefinitionContext result = CustomResourceDefinitionContext.fromCrd((io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)crd);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("group", (Object)"the-foo.com")).hasFieldOrPropertyWithValue("version", (Object)"v1")).hasFieldOrPropertyWithValue("scope", (Object)"Namespaced")).hasFieldOrPropertyWithValue("name", (Object)"foobar.the-foo.com")).hasFieldOrPropertyWithValue("plural", (Object)"foobars")).hasFieldOrPropertyWithValue("kind", (Object)"Foobar");
    }

    @Test
    @DisplayName(value="fromCrd, with v1beta1 CRD with versions, should infer correct properties")
    void fromCrdV1beta1() {
        CustomResourceDefinition crd = ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.VersionsNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.VersionsNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.VersionsNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)new CustomResourceDefinitionBuilder().withNewMetadata().withName("foobar.the-foo.com")).endMetadata()).withNewSpec().withGroup("the-foo.com")).withScope("Namespaced")).withNewNames().withSingular("foobar")).withPlural("foobars")).withKind("Foobar")).endNames()).addNewVersion().withName("v1beta1")).endVersion()).addNewVersion().withName("v1alpha1")).endVersion()).addNewVersion().withName("v1")).endVersion()).endSpec()).build();
        CustomResourceDefinitionContext result = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)crd);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("group", (Object)"the-foo.com")).hasFieldOrPropertyWithValue("version", (Object)"v1")).hasFieldOrPropertyWithValue("scope", (Object)"Namespaced")).hasFieldOrPropertyWithValue("name", (Object)"foobar.the-foo.com")).hasFieldOrPropertyWithValue("plural", (Object)"foobars")).hasFieldOrPropertyWithValue("kind", (Object)"Foobar");
    }

    @Test
    @DisplayName(value="fromCrd, with v1beta1 CRD with spec.version, should infer correct properties")
    void fromCrdV1beta1OldVersionStyle() {
        CustomResourceDefinition crd = ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)new CustomResourceDefinitionBuilder().withNewMetadata().withName("foobar.the-foo.com")).endMetadata()).withNewSpec().withGroup("the-foo.com")).withScope("Namespaced")).withNewNames().withSingular("foobar")).withPlural("foobars")).withKind("Foobar")).endNames()).withVersion("v1")).endSpec()).build();
        CustomResourceDefinitionContext result = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)crd);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("group", (Object)"the-foo.com")).hasFieldOrPropertyWithValue("version", (Object)"v1")).hasFieldOrPropertyWithValue("scope", (Object)"Namespaced")).hasFieldOrPropertyWithValue("name", (Object)"foobar.the-foo.com")).hasFieldOrPropertyWithValue("plural", (Object)"foobars")).hasFieldOrPropertyWithValue("kind", (Object)"Foobar");
    }

    @Test
    void isNamespaceScoped() {
        CustomResourceDefinitionContext crdc1 = new CustomResourceDefinitionContext.Builder().withPlural("values").withScope("Namespaced").build();
        CustomResourceDefinitionContext crdc2 = new CustomResourceDefinitionContext.Builder().withPlural("values").withScope("Cluster").build();
        Assertions.assertThat((boolean)crdc1.isNamespaceScoped()).isTrue();
        Assertions.assertThat((boolean)crdc2.isNamespaceScoped()).isFalse();
    }
}

