/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TypeInferenceTest {
    TypeInferenceTest() {
    }

    @Test
    void typeInferenceWithLambda() {
        ConfigMapDependentResource cdr = new ConfigMapDependentResource();
        DeploymentDependentResource ddr = new DeploymentDependentResource();
        Arrays.asList(cdr, ddr).forEach(dr -> dr.reconcile());
        Assertions.assertTrue((boolean)true);
    }

    @Test
    void typeInferenceWithMethodReference() {
        ConfigMapDependentResource cdr = new ConfigMapDependentResource();
        DeploymentDependentResource ddr = new DeploymentDependentResource();
        Arrays.asList(cdr, ddr).forEach(KubernetesDependentResource::reconcile);
        Assertions.assertTrue((boolean)true);
    }

    static final class DeploymentDependentResource
    extends KubernetesDependentResource<Deployment, Service> {
        DeploymentDependentResource() {
        }
    }

    static final class ConfigMapDependentResource
    extends KubernetesDependentResource<ConfigMap, Service> {
        ConfigMapDependentResource() {
        }
    }

    static interface DependentResourceConfigurator<C> {
        public void configureWith(C var1);

        public Optional<C> configuration();
    }

    static class KubernetesDependentConfig<R extends HasMetadata> {
        KubernetesDependentConfig() {
        }
    }

    static abstract class KubernetesDependentResource<R extends HasMetadata, P extends HasMetadata>
    implements DependentResourceConfigurator<KubernetesDependentConfig<R>> {
        KubernetesDependentResource() {
        }

        void reconcile() {
        }

        @Override
        public void configureWith(KubernetesDependentConfig<R> config) {
        }

        @Override
        public Optional<KubernetesDependentConfig<R>> configuration() {
            return Optional.empty();
        }
    }
}

