/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions.support;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.assertions.support.PodWatcher;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PodLogWatcher
implements Closeable {
    private final LogWatch logWatch;

    public PodLogWatcher(PodWatcher podWatcher, String name, Pod pod, String containerName, File logFile) throws FileNotFoundException {
        KubernetesClient client = podWatcher.getClient();
        ObjectMeta metadata = pod.getMetadata();
        logFile.getParentFile().mkdirs();
        PodSpec spec = pod.getSpec();
        this.logWatch = (LogWatch)((ContainerResource)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(metadata.getNamespace())).withName(name)).inContainer((Object)containerName)).watchLog((OutputStream)new FileOutputStream(logFile));
    }

    @Override
    public void close() throws IOException {
        if (this.logWatch != null) {
            this.logWatch.close();
        }
    }
}

