/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.ClusterRoleFluent;
import io.fabric8.openshift.api.model.PolicyRule;
import io.fabric8.openshift.api.model.PolicyRuleBuilder;
import io.fabric8.openshift.api.model.PolicyRuleFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClusterRoleFluentImpl<A extends ClusterRoleFluent<A>>
extends BaseFluent<A>
implements ClusterRoleFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<PolicyRuleBuilder> rules = new ArrayList<PolicyRuleBuilder>();

    public ClusterRoleFluentImpl() {
    }

    public ClusterRoleFluentImpl(ClusterRole instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ClusterRoleFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterRoleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterRoleFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ClusterRoleFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ClusterRoleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRules(int index, PolicyRule item) {
        PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.rules.add(index >= 0 ? index : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(int index, PolicyRule item) {
        PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(PolicyRule ... items) {
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<PolicyRule> items) {
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(PolicyRule ... items) {
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<PolicyRule> items) {
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PolicyRule> getRules() {
        return ClusterRoleFluentImpl.build(this.rules);
    }

    @Override
    public List<PolicyRule> buildRules() {
        return ClusterRoleFluentImpl.build(this.rules);
    }

    @Override
    public PolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public PolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public PolicyRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public PolicyRule buildMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        for (PolicyRuleBuilder item : this.rules) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withRules(List<PolicyRule> rules) {
        this._visitables.removeAll(this.rules);
        this.rules.clear();
        if (rules != null) {
            for (PolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRules(PolicyRule ... rules) {
        this.rules.clear();
        if (rules != null) {
            for (PolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public ClusterRoleFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public ClusterRoleFluent.RulesNested<A> addNewRuleLike(PolicyRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public ClusterRoleFluent.RulesNested<A> setNewRuleLike(int index, PolicyRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public ClusterRoleFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public ClusterRoleFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public ClusterRoleFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public ClusterRoleFluent.RulesNested<A> editMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.apply((Object)this.rules.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleFluentImpl that = (ClusterRoleFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public class RulesNestedImpl<N>
    extends PolicyRuleFluentImpl<ClusterRoleFluent.RulesNested<N>>
    implements ClusterRoleFluent.RulesNested<N>,
    Nested<N> {
        private final PolicyRuleBuilder builder;
        private final int index;

        RulesNestedImpl(int index, PolicyRule item) {
            this.index = index;
            this.builder = new PolicyRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new PolicyRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterRoleFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterRoleFluent.MetadataNested<N>>
    implements ClusterRoleFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterRoleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

