/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.ImageLabel;
import io.fabric8.openshift.api.model.ImageLabelBuilder;
import io.fabric8.openshift.api.model.ImageLabelFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BuildOutputFluentImpl<A extends BuildOutputFluent<A>>
extends BaseFluent<A>
implements BuildOutputFluent<A> {
    private List<ImageLabelBuilder> imageLabels = new ArrayList<ImageLabelBuilder>();
    private LocalObjectReferenceBuilder pushSecret;
    private ObjectReferenceBuilder to;

    public BuildOutputFluentImpl() {
    }

    public BuildOutputFluentImpl(BuildOutput instance) {
        this.withImageLabels(instance.getImageLabels());
        this.withPushSecret(instance.getPushSecret());
        this.withTo(instance.getTo());
    }

    @Override
    public A addToImageLabels(int index, ImageLabel item) {
        ImageLabelBuilder builder = new ImageLabelBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.imageLabels.add(index >= 0 ? index : this.imageLabels.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImageLabels(int index, ImageLabel item) {
        ImageLabelBuilder builder = new ImageLabelBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.imageLabels.size()) {
            this.imageLabels.add(builder);
        } else {
            this.imageLabels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImageLabels(ImageLabel ... items) {
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.add(builder);
            this.imageLabels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImageLabels(Collection<ImageLabel> items) {
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.add(builder);
            this.imageLabels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImageLabels(ImageLabel ... items) {
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.remove(builder);
            this.imageLabels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImageLabels(Collection<ImageLabel> items) {
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.remove(builder);
            this.imageLabels.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageLabel> getImageLabels() {
        return BuildOutputFluentImpl.build(this.imageLabels);
    }

    @Override
    public List<ImageLabel> buildImageLabels() {
        return BuildOutputFluentImpl.build(this.imageLabels);
    }

    @Override
    public ImageLabel buildImageLabel(int index) {
        return this.imageLabels.get(index).build();
    }

    @Override
    public ImageLabel buildFirstImageLabel() {
        return this.imageLabels.get(0).build();
    }

    @Override
    public ImageLabel buildLastImageLabel() {
        return this.imageLabels.get(this.imageLabels.size() - 1).build();
    }

    @Override
    public ImageLabel buildMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        for (ImageLabelBuilder item : this.imageLabels) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withImageLabels(List<ImageLabel> imageLabels) {
        this._visitables.removeAll(this.imageLabels);
        this.imageLabels.clear();
        if (imageLabels != null) {
            for (ImageLabel item : imageLabels) {
                this.addToImageLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withImageLabels(ImageLabel ... imageLabels) {
        this.imageLabels.clear();
        if (imageLabels != null) {
            for (ImageLabel item : imageLabels) {
                this.addToImageLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImageLabels() {
        return this.imageLabels != null && !this.imageLabels.isEmpty();
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> addNewImageLabel() {
        return new ImageLabelsNestedImpl();
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> addNewImageLabelLike(ImageLabel item) {
        return new ImageLabelsNestedImpl(-1, item);
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> setNewImageLabelLike(int index, ImageLabel item) {
        return new ImageLabelsNestedImpl(index, item);
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> editImageLabel(int index) {
        if (this.imageLabels.size() <= index) {
            throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> editFirstImageLabel() {
        if (this.imageLabels.size() == 0) {
            throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
        }
        return this.setNewImageLabelLike(0, this.buildImageLabel(0));
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> editLastImageLabel() {
        int index = this.imageLabels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> editMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageLabels.size(); ++i) {
            if (!predicate.apply((Object)this.imageLabels.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imageLabels. No match found.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    public A addNewImageLabel(String name, String value) {
        return this.addToImageLabels(new ImageLabel(name, value));
    }

    @Override
    @Deprecated
    public LocalObjectReference getPushSecret() {
        return this.pushSecret != null ? this.pushSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildPushSecret() {
        return this.pushSecret != null ? this.pushSecret.build() : null;
    }

    @Override
    public A withPushSecret(LocalObjectReference pushSecret) {
        this._visitables.remove(this.pushSecret);
        if (pushSecret != null) {
            this.pushSecret = new LocalObjectReferenceBuilder(pushSecret);
            this._visitables.add(this.pushSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPushSecret() {
        return this.pushSecret != null;
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> withNewPushSecret() {
        return new PushSecretNestedImpl();
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> withNewPushSecretLike(LocalObjectReference item) {
        return new PushSecretNestedImpl(item);
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> editPushSecret() {
        return this.withNewPushSecretLike(this.getPushSecret());
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> editOrNewPushSecret() {
        return this.withNewPushSecretLike(this.getPushSecret() != null ? this.getPushSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> editOrNewPushSecretLike(LocalObjectReference item) {
        return this.withNewPushSecretLike(this.getPushSecret() != null ? this.getPushSecret() : item);
    }

    @Override
    public A withNewPushSecret(String name) {
        return this.withPushSecret(new LocalObjectReference(name));
    }

    @Override
    @Deprecated
    public ObjectReference getTo() {
        return this.to != null ? this.to.build() : null;
    }

    @Override
    public ObjectReference buildTo() {
        return this.to != null ? this.to.build() : null;
    }

    @Override
    public A withTo(ObjectReference to) {
        this._visitables.remove(this.to);
        if (to != null) {
            this.to = new ObjectReferenceBuilder(to);
            this._visitables.add(this.to);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTo() {
        return this.to != null;
    }

    @Override
    public BuildOutputFluent.ToNested<A> withNewTo() {
        return new ToNestedImpl();
    }

    @Override
    public BuildOutputFluent.ToNested<A> withNewToLike(ObjectReference item) {
        return new ToNestedImpl(item);
    }

    @Override
    public BuildOutputFluent.ToNested<A> editTo() {
        return this.withNewToLike(this.getTo());
    }

    @Override
    public BuildOutputFluent.ToNested<A> editOrNewTo() {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BuildOutputFluent.ToNested<A> editOrNewToLike(ObjectReference item) {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildOutputFluentImpl that = (BuildOutputFluentImpl)o;
        if (this.imageLabels != null ? !this.imageLabels.equals(that.imageLabels) : that.imageLabels != null) {
            return false;
        }
        if (this.pushSecret != null ? !this.pushSecret.equals(that.pushSecret) : that.pushSecret != null) {
            return false;
        }
        return !(this.to != null ? !this.to.equals(that.to) : that.to != null);
    }

    public class ToNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildOutputFluent.ToNested<N>>
    implements BuildOutputFluent.ToNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        ToNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ToNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildOutputFluentImpl.this.withTo(this.builder.build());
        }

        @Override
        public N endTo() {
            return this.and();
        }
    }

    public class PushSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<BuildOutputFluent.PushSecretNested<N>>
    implements BuildOutputFluent.PushSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        PushSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PushSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildOutputFluentImpl.this.withPushSecret(this.builder.build());
        }

        @Override
        public N endPushSecret() {
            return this.and();
        }
    }

    public class ImageLabelsNestedImpl<N>
    extends ImageLabelFluentImpl<BuildOutputFluent.ImageLabelsNested<N>>
    implements BuildOutputFluent.ImageLabelsNested<N>,
    Nested<N> {
        private final ImageLabelBuilder builder;
        private final int index;

        ImageLabelsNestedImpl(int index, ImageLabel item) {
            this.index = index;
            this.builder = new ImageLabelBuilder(this, item);
        }

        ImageLabelsNestedImpl() {
            this.index = -1;
            this.builder = new ImageLabelBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildOutputFluentImpl.this.setToImageLabels(this.index, this.builder.build());
        }

        @Override
        public N endImageLabel() {
            return this.and();
        }
    }
}

