/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ResourceRequirementsAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildOutputAssert;
import io.fabric8.openshift.api.model.BuildPostCommitSpecAssert;
import io.fabric8.openshift.api.model.BuildSourceAssert;
import io.fabric8.openshift.api.model.BuildStrategyAssert;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.BuildTriggerPolicyAssert;
import io.fabric8.openshift.api.model.SourceRevisionAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractBuildConfigSpecAssert<S extends AbstractBuildConfigSpecAssert<S, A>, A extends BuildConfigSpec>
extends AbstractAssert<S, A> {
    protected AbstractBuildConfigSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((BuildConfigSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting completionDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualCompletionDeadlineSeconds = ((BuildConfigSpec)this.actual).getCompletionDeadlineSeconds();
        if (!Objects.areEqual((Object)actualCompletionDeadlineSeconds, (Object)completionDeadlineSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, completionDeadlineSeconds, actualCompletionDeadlineSeconds});
        }
        return (S)((Object)((AbstractBuildConfigSpecAssert)this.myself));
    }

    public S hasFailedBuildsHistoryLimit(Integer failedBuildsHistoryLimit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting failedBuildsHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualFailedBuildsHistoryLimit = ((BuildConfigSpec)this.actual).getFailedBuildsHistoryLimit();
        if (!Objects.areEqual((Object)actualFailedBuildsHistoryLimit, (Object)failedBuildsHistoryLimit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, failedBuildsHistoryLimit, actualFailedBuildsHistoryLimit});
        }
        return (S)((Object)((AbstractBuildConfigSpecAssert)this.myself));
    }

    public MapAssert nodeSelector() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((BuildConfigSpec)this.actual).getNodeSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeSelector"), new Object[0]);
    }

    public BuildOutputAssert output() {
        this.isNotNull();
        return (BuildOutputAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildConfigSpec)this.actual).getOutput()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "output"), new Object[0]);
    }

    public BuildPostCommitSpecAssert postCommit() {
        this.isNotNull();
        return (BuildPostCommitSpecAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildConfigSpec)this.actual).getPostCommit()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "postCommit"), new Object[0]);
    }

    public ResourceRequirementsAssert resources() {
        this.isNotNull();
        return (ResourceRequirementsAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildConfigSpec)this.actual).getResources()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resources"), new Object[0]);
    }

    public SourceRevisionAssert revision() {
        this.isNotNull();
        return (SourceRevisionAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildConfigSpec)this.actual).getRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "revision"), new Object[0]);
    }

    public StringAssert runPolicy() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((BuildConfigSpec)this.actual).getRunPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runPolicy"), new Object[0]);
    }

    public StringAssert serviceAccount() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((BuildConfigSpec)this.actual).getServiceAccount()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccount"), new Object[0]);
    }

    public BuildSourceAssert source() {
        this.isNotNull();
        return (BuildSourceAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildConfigSpec)this.actual).getSource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "source"), new Object[0]);
    }

    public BuildStrategyAssert strategy() {
        this.isNotNull();
        return (BuildStrategyAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildConfigSpec)this.actual).getStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "strategy"), new Object[0]);
    }

    public S hasSuccessfulBuildsHistoryLimit(Integer successfulBuildsHistoryLimit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting successfulBuildsHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualSuccessfulBuildsHistoryLimit = ((BuildConfigSpec)this.actual).getSuccessfulBuildsHistoryLimit();
        if (!Objects.areEqual((Object)actualSuccessfulBuildsHistoryLimit, (Object)successfulBuildsHistoryLimit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, successfulBuildsHistoryLimit, actualSuccessfulBuildsHistoryLimit});
        }
        return (S)((Object)((AbstractBuildConfigSpecAssert)this.myself));
    }

    public NavigationListAssert<BuildTriggerPolicy, BuildTriggerPolicyAssert> triggers() {
        this.isNotNull();
        AssertFactory<BuildTriggerPolicy, BuildTriggerPolicyAssert> assertFactory = new AssertFactory<BuildTriggerPolicy, BuildTriggerPolicyAssert>(){

            @Override
            public BuildTriggerPolicyAssert createAssert(BuildTriggerPolicy t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<BuildTriggerPolicy, BuildTriggerPolicyAssert> answer = new NavigationListAssert<BuildTriggerPolicy, BuildTriggerPolicyAssert>(((BuildConfigSpec)this.actual).getTriggers(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "triggers"), new Object[0]);
        return answer;
    }
}

