/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetStatus;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetStatusFluent;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetStatusFluentImpl;

public class StatefulSetStatusBuilder
extends StatefulSetStatusFluentImpl<StatefulSetStatusBuilder>
implements VisitableBuilder<StatefulSetStatus, StatefulSetStatusBuilder> {
    StatefulSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetStatusBuilder() {
        this(true);
    }

    public StatefulSetStatusBuilder(Boolean validationEnabled) {
        this(new StatefulSetStatus(), validationEnabled);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetStatus(), validationEnabled);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, StatefulSetStatus instance) {
        this(fluent, instance, true);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, StatefulSetStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCurrentReplicas(instance.getCurrentReplicas());
        fluent.withCurrentRevision(instance.getCurrentRevision());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReadyReplicas(instance.getReadyReplicas());
        fluent.withReplicas(instance.getReplicas());
        fluent.withUpdateRevision(instance.getUpdateRevision());
        fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetStatusBuilder(StatefulSetStatus instance) {
        this(instance, (Boolean)true);
    }

    public StatefulSetStatusBuilder(StatefulSetStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withCurrentRevision(instance.getCurrentRevision());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.withUpdateRevision(instance.getUpdateRevision());
        this.withUpdatedReplicas(instance.getUpdatedReplicas());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetStatus build() {
        StatefulSetStatus buildable = new StatefulSetStatus(this.fluent.getCurrentReplicas(), this.fluent.getCurrentRevision(), this.fluent.getObservedGeneration(), this.fluent.getReadyReplicas(), this.fluent.getReplicas(), this.fluent.getUpdateRevision(), this.fluent.getUpdatedReplicas());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetStatusBuilder that = (StatefulSetStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

